/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.FactoryIdentityType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.UUID;

public class FactoryIdentity {
    @JsonProperty(value="type", required=true)
    private FactoryIdentityType type;
    @JsonProperty(value="principalId", access=JsonProperty.Access.WRITE_ONLY)
    private UUID principalId;
    @JsonProperty(value="tenantId", access=JsonProperty.Access.WRITE_ONLY)
    private UUID tenantId;
    @JsonProperty(value="userAssignedIdentities")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, Object> userAssignedIdentities;
    private static final ClientLogger LOGGER = new ClientLogger(FactoryIdentity.class);

    public FactoryIdentityType type() {
        return this.type;
    }

    public FactoryIdentity withType(FactoryIdentityType type) {
        this.type = type;
        return this;
    }

    public UUID principalId() {
        return this.principalId;
    }

    public UUID tenantId() {
        return this.tenantId;
    }

    public Map<String, Object> userAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    public FactoryIdentity withUserAssignedIdentities(Map<String, Object> userAssignedIdentities) {
        this.userAssignedIdentities = userAssignedIdentities;
        return this;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property type in model FactoryIdentity"));
        }
    }
}

