/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.extract.base.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundInvoker;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.extract.base.IRpcResponse;
import org.apache.dolphinscheduler.extract.base.RpcMethodRetryStrategy;
import org.apache.dolphinscheduler.extract.base.SyncRequestDto;
import org.apache.dolphinscheduler.extract.base.client.NettyClientHandler;
import org.apache.dolphinscheduler.extract.base.config.NettyClientConfig;
import org.apache.dolphinscheduler.extract.base.exception.RemoteException;
import org.apache.dolphinscheduler.extract.base.exception.RemoteTimeoutException;
import org.apache.dolphinscheduler.extract.base.future.ResponseFuture;
import org.apache.dolphinscheduler.extract.base.metrics.ClientSyncDurationMetrics;
import org.apache.dolphinscheduler.extract.base.metrics.ClientSyncExceptionMetrics;
import org.apache.dolphinscheduler.extract.base.metrics.RpcMetrics;
import org.apache.dolphinscheduler.extract.base.protocal.Transporter;
import org.apache.dolphinscheduler.extract.base.protocal.TransporterDecoder;
import org.apache.dolphinscheduler.extract.base.protocal.TransporterEncoder;
import org.apache.dolphinscheduler.extract.base.utils.Host;
import org.apache.dolphinscheduler.extract.base.utils.NettyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyRemotingClient
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NettyRemotingClient.class);
    private final Bootstrap bootstrap = new Bootstrap();
    private final ReentrantLock channelsLock = new ReentrantLock();
    private final Map<Host, Channel> channels = new ConcurrentHashMap<Host, Channel>();
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    private final EventLoopGroup workerGroup;
    private final NettyClientConfig clientConfig;
    private final NettyClientHandler clientHandler;

    public NettyRemotingClient(NettyClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        ThreadFactory nettyClientThreadFactory = ThreadUtils.newDaemonThreadFactory((String)"NettyClientThread-");
        this.workerGroup = Epoll.isAvailable() ? new EpollEventLoopGroup(clientConfig.getWorkerThreads(), nettyClientThreadFactory) : new NioEventLoopGroup(clientConfig.getWorkerThreads(), nettyClientThreadFactory);
        this.clientHandler = new NettyClientHandler(this);
        this.start();
    }

    private void start() {
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(this.workerGroup)).channel(NettyUtils.getSocketChannelClass())).option(ChannelOption.SO_KEEPALIVE, (Object)this.clientConfig.isSoKeepalive())).option(ChannelOption.TCP_NODELAY, (Object)this.clientConfig.isTcpNoDelay())).option(ChannelOption.SO_SNDBUF, (Object)this.clientConfig.getSendBufferSize())).option(ChannelOption.SO_RCVBUF, (Object)this.clientConfig.getReceiveBufferSize())).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.clientConfig.getConnectTimeoutMillis())).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) {
                ch.pipeline().addLast("client-idle-handler", (ChannelHandler)new IdleStateHandler(0L, NettyRemotingClient.this.clientConfig.getHeartBeatIntervalMillis(), 0L, TimeUnit.MILLISECONDS)).addLast(new ChannelHandler[]{new TransporterDecoder(), NettyRemotingClient.this.clientHandler, new TransporterEncoder()});
            }
        });
        this.isStarted.compareAndSet(false, true);
    }

    public IRpcResponse sendSync(SyncRequestDto syncRequestDto) throws RemoteException {
        Host host = syncRequestDto.getServerHost();
        Transporter transporter = syncRequestDto.getTransporter();
        long timeoutMillis = syncRequestDto.getTimeoutMillis() < 0L ? (long)this.clientConfig.getDefaultRpcTimeoutMillis() : syncRequestDto.getTimeoutMillis();
        RpcMethodRetryStrategy retryStrategy = syncRequestDto.getRetryStrategy();
        int maxRetryTimes = retryStrategy.maxRetryTimes();
        int currentExecuteTimes = 1;
        while (true) {
            long start = System.currentTimeMillis();
            try {
                IRpcResponse iRpcResponse = this.doSendSync(transporter, host, timeoutMillis);
                return iRpcResponse;
            }
            catch (Exception ex) {
                ClientSyncExceptionMetrics clientSyncExceptionMetrics = ClientSyncExceptionMetrics.of(syncRequestDto, ex);
                RpcMetrics.recordClientSyncRequestException(clientSyncExceptionMetrics);
                if (currentExecuteTimes < maxRetryTimes && Arrays.stream(retryStrategy.retryFor()).anyMatch(e -> e.isInstance(ex))) {
                    ++currentExecuteTimes;
                    if (retryStrategy.retryInterval() <= 0L) continue;
                    ThreadUtils.sleep((long)retryStrategy.retryInterval());
                    continue;
                }
                if (ex instanceof RemoteException) {
                    throw (RemoteException)ex;
                }
                throw new RemoteException("Call method to " + host + " failed", ex);
            }
            finally {
                ClientSyncDurationMetrics clientSyncDurationMetrics = ClientSyncDurationMetrics.of(syncRequestDto).withMilliseconds(System.currentTimeMillis() - start);
                RpcMetrics.recordClientSyncRequestDuration(clientSyncDurationMetrics);
                continue;
            }
            break;
        }
    }

    private IRpcResponse doSendSync(Transporter transporter, Host serverHost, long timeoutMills) throws RemoteException, InterruptedException {
        Channel channel = this.getOrCreateChannel(serverHost);
        if (channel == null) {
            throw new RemoteException(String.format("connect to : %s fail", serverHost));
        }
        ResponseFuture responseFuture = new ResponseFuture(transporter.getHeader().getOpaque(), timeoutMills);
        channel.writeAndFlush((Object)transporter).addListener(future -> {
            if (future.isSuccess()) {
                responseFuture.setSendOk(true);
                return;
            }
            responseFuture.setSendOk(false);
            responseFuture.setCause(future.cause());
            responseFuture.putResponse(null);
            log.error("Send Sync request {} to host {} failed", new Object[]{transporter, serverHost, responseFuture.getCause()});
        });
        IRpcResponse iRpcResponse = responseFuture.waitResponse();
        if (iRpcResponse != null) {
            return iRpcResponse;
        }
        if (responseFuture.isSendOK()) {
            throw new RemoteTimeoutException(serverHost.toString(), timeoutMills, responseFuture.getCause());
        }
        throw new RemoteException(serverHost.toString(), responseFuture.getCause());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Channel getOrCreateChannel(Host host) {
        Channel channel = this.channels.get(host);
        if (channel != null && channel.isActive()) {
            return channel;
        }
        try {
            this.channelsLock.lock();
            channel = this.channels.get(host);
            if (channel != null && channel.isActive()) {
                Channel channel2 = channel;
                return channel2;
            }
            channel = this.createChannel(host);
            this.channels.put(host, channel);
        }
        finally {
            this.channelsLock.unlock();
        }
        return channel;
    }

    Channel createChannel(Host host) {
        try {
            ChannelFuture future = this.bootstrap.connect((SocketAddress)new InetSocketAddress(host.getIp(), host.getPort()));
            future = future.sync();
            if (future.isSuccess()) {
                return future.channel();
            }
            throw new IllegalArgumentException("connect to host: " + host + " failed", future.cause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Connect to host: " + host + " failed", e);
        }
    }

    @Override
    public void close() {
        if (this.isStarted.compareAndSet(true, false)) {
            try {
                this.closeChannels();
                if (this.workerGroup != null) {
                    this.workerGroup.shutdownGracefully();
                }
                log.info("netty client closed");
            }
            catch (Exception ex) {
                log.error("netty client close exception", (Throwable)ex);
            }
        }
    }

    private void closeChannels() {
        try {
            this.channelsLock.lock();
            this.channels.values().forEach(ChannelOutboundInvoker::close);
            this.channels.clear();
        }
        finally {
            this.channelsLock.unlock();
        }
    }

    public void onChannelInactive(Host host) {
        this.channels.remove(host);
    }
}

