/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.kinesis.supervisor;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nullable;
import org.apache.druid.indexing.kinesis.KinesisIndexTaskTuningConfig;
import org.apache.druid.indexing.seekablestream.supervisor.SeekableStreamSupervisorTuningConfig;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.incremental.AppendableIndexSpec;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.joda.time.Duration;
import org.joda.time.Period;

public class KinesisSupervisorTuningConfig
extends KinesisIndexTaskTuningConfig
implements SeekableStreamSupervisorTuningConfig {
    private final Integer workerThreads;
    private final Long chatRetries;
    private final Duration httpTimeout;
    private final Duration shutdownTimeout;
    private final Duration repartitionTransitionDuration;
    private final Duration offsetFetchPeriod;
    private final boolean useListShards;

    public static KinesisSupervisorTuningConfig defaultConfig() {
        return new KinesisSupervisorTuningConfig(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public KinesisSupervisorTuningConfig(@JsonProperty(value="appendableIndexSpec") @Nullable AppendableIndexSpec appendableIndexSpec, @JsonProperty(value="maxRowsInMemory") Integer maxRowsInMemory, @JsonProperty(value="maxBytesInMemory") Long maxBytesInMemory, @JsonProperty(value="skipBytesInMemoryOverheadCheck") @Nullable Boolean skipBytesInMemoryOverheadCheck, @JsonProperty(value="maxRowsPerSegment") Integer maxRowsPerSegment, @JsonProperty(value="maxTotalRows") Long maxTotalRows, @JsonProperty(value="intermediatePersistPeriod") Period intermediatePersistPeriod, @JsonProperty(value="maxPendingPersists") Integer maxPendingPersists, @JsonProperty(value="indexSpec") IndexSpec indexSpec, @JsonProperty(value="indexSpecForIntermediatePersists") @Nullable IndexSpec indexSpecForIntermediatePersists, @JsonProperty(value="reportParseExceptions") Boolean reportParseExceptions, @JsonProperty(value="handoffConditionTimeout") Long handoffConditionTimeout, @JsonProperty(value="resetOffsetAutomatically") Boolean resetOffsetAutomatically, @JsonProperty(value="skipSequenceNumberAvailabilityCheck") Boolean skipSequenceNumberAvailabilityCheck, @JsonProperty(value="segmentWriteOutMediumFactory") @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory, @JsonProperty(value="workerThreads") Integer workerThreads, @JsonProperty(value="chatRetries") Long chatRetries, @JsonProperty(value="httpTimeout") Period httpTimeout, @JsonProperty(value="shutdownTimeout") Period shutdownTimeout, @JsonProperty(value="recordBufferSize") @Deprecated @Nullable Integer recordBufferSize, @JsonProperty(value="recordBufferSizeBytes") Integer recordBufferSizeBytes, @JsonProperty(value="recordBufferOfferTimeout") Integer recordBufferOfferTimeout, @JsonProperty(value="recordBufferFullWait") Integer recordBufferFullWait, @JsonProperty(value="fetchThreads") Integer fetchThreads, @JsonProperty(value="logParseExceptions") @Nullable Boolean logParseExceptions, @JsonProperty(value="maxParseExceptions") @Nullable Integer maxParseExceptions, @JsonProperty(value="maxSavedParseExceptions") @Nullable Integer maxSavedParseExceptions, @JsonProperty(value="maxRecordsPerPoll") @Deprecated @Nullable Integer maxRecordsPerPoll, @JsonProperty(value="maxBytesPerPoll") @Nullable Integer maxBytesPerPoll, @JsonProperty(value="intermediateHandoffPeriod") Period intermediateHandoffPeriod, @JsonProperty(value="repartitionTransitionDuration") Period repartitionTransitionDuration, @JsonProperty(value="offsetFetchPeriod") Period offsetFetchPeriod, @JsonProperty(value="useListShards") Boolean useListShards, @JsonProperty(value="maxColumnsToMerge") Integer maxColumnsToMerge) {
        super(appendableIndexSpec, maxRowsInMemory, maxBytesInMemory, skipBytesInMemoryOverheadCheck, maxRowsPerSegment, maxTotalRows, intermediatePersistPeriod, null, maxPendingPersists, indexSpec, indexSpecForIntermediatePersists, reportParseExceptions, handoffConditionTimeout, resetOffsetAutomatically, skipSequenceNumberAvailabilityCheck, recordBufferSize, recordBufferSizeBytes, recordBufferOfferTimeout, recordBufferFullWait, fetchThreads, segmentWriteOutMediumFactory, logParseExceptions, maxParseExceptions, maxSavedParseExceptions, maxRecordsPerPoll, maxBytesPerPoll, intermediateHandoffPeriod, maxColumnsToMerge);
        this.workerThreads = workerThreads;
        this.chatRetries = chatRetries != null ? chatRetries : 8L;
        this.httpTimeout = SeekableStreamSupervisorTuningConfig.defaultDuration((Period)httpTimeout, (String)"PT10S");
        this.shutdownTimeout = SeekableStreamSupervisorTuningConfig.defaultDuration((Period)shutdownTimeout, (String)"PT80S");
        this.repartitionTransitionDuration = SeekableStreamSupervisorTuningConfig.defaultDuration((Period)repartitionTransitionDuration, (String)"PT2M");
        this.offsetFetchPeriod = SeekableStreamSupervisorTuningConfig.defaultDuration((Period)offsetFetchPeriod, (String)"PT30S");
        this.useListShards = useListShards != null ? useListShards : false;
    }

    @JsonProperty
    public Integer getWorkerThreads() {
        return this.workerThreads;
    }

    @JsonProperty
    public Long getChatRetries() {
        return this.chatRetries;
    }

    @JsonProperty
    public Duration getHttpTimeout() {
        return this.httpTimeout;
    }

    @JsonProperty
    public Duration getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public Duration getRepartitionTransitionDuration() {
        return this.repartitionTransitionDuration;
    }

    @JsonProperty
    public Duration getOffsetFetchPeriod() {
        return this.offsetFetchPeriod;
    }

    @JsonProperty
    public boolean isUseListShards() {
        return this.useListShards;
    }

    @Override
    public String toString() {
        return "KinesisSupervisorTuningConfig{maxRowsInMemory=" + this.getMaxRowsInMemory() + ", maxBytesInMemory=" + this.getMaxBytesInMemory() + ", skipBytesInMemoryOverheadCheck=" + this.isSkipBytesInMemoryOverheadCheck() + ", maxRowsPerSegment=" + this.getMaxRowsPerSegment() + ", maxTotalRows=" + this.getMaxTotalRows() + ", intermediatePersistPeriod=" + String.valueOf(this.getIntermediatePersistPeriod()) + ", maxPendingPersists=" + this.getMaxPendingPersists() + ", indexSpec=" + String.valueOf(this.getIndexSpec()) + ", reportParseExceptions=" + this.isReportParseExceptions() + ", handoffConditionTimeout=" + this.getHandoffConditionTimeout() + ", resetOffsetAutomatically=" + this.isResetOffsetAutomatically() + ", skipSequenceNumberAvailabilityCheck=" + this.isSkipSequenceNumberAvailabilityCheck() + ", workerThreads=" + this.workerThreads + ", chatRetries=" + this.chatRetries + ", httpTimeout=" + String.valueOf(this.httpTimeout) + ", shutdownTimeout=" + String.valueOf(this.shutdownTimeout) + ", recordBufferSizeBytes=" + this.getRecordBufferSizeBytesConfigured() + ", recordBufferOfferTimeout=" + this.getRecordBufferOfferTimeout() + ", recordBufferFullWait=" + this.getRecordBufferFullWait() + ", fetchThreads=" + this.getFetchThreads() + ", segmentWriteOutMediumFactory=" + String.valueOf(this.getSegmentWriteOutMediumFactory()) + ", logParseExceptions=" + this.isLogParseExceptions() + ", maxParseExceptions=" + this.getMaxParseExceptions() + ", maxSavedParseExceptions=" + this.getMaxSavedParseExceptions() + ", maxRecordsPerPoll=" + this.getMaxRecordsPerPollConfigured() + ", maxBytesPerPoll=" + this.getMaxBytesPerPollConfigured() + ", intermediateHandoffPeriod=" + String.valueOf(this.getIntermediateHandoffPeriod()) + ", repartitionTransitionDuration=" + String.valueOf(this.getRepartitionTransitionDuration()) + ", useListShards=" + this.isUseListShards() + ", maxColumnsToMerge=" + this.getMaxColumnsToMerge() + "}";
    }

    public KinesisIndexTaskTuningConfig convertToTaskTuningConfig() {
        return new KinesisIndexTaskTuningConfig(this.getAppendableIndexSpec(), this.getMaxRowsInMemory(), this.getMaxBytesInMemory(), this.isSkipBytesInMemoryOverheadCheck(), this.getMaxRowsPerSegment(), this.getMaxTotalRows(), this.getIntermediatePersistPeriod(), null, this.getMaxPendingPersists(), this.getIndexSpec(), this.getIndexSpecForIntermediatePersists(), this.isReportParseExceptions(), this.getHandoffConditionTimeout(), this.isResetOffsetAutomatically(), this.isSkipSequenceNumberAvailabilityCheck(), this.getRecordBufferSizeConfigured(), this.getRecordBufferSizeBytesConfigured(), this.getRecordBufferOfferTimeout(), this.getRecordBufferFullWait(), this.getFetchThreads(), this.getSegmentWriteOutMediumFactory(), this.isLogParseExceptions(), this.getMaxParseExceptions(), this.getMaxSavedParseExceptions(), this.getMaxRecordsPerPollConfigured(), this.getMaxBytesPerPollConfigured(), this.getIntermediateHandoffPeriod(), this.getMaxColumnsToMerge());
    }
}

