/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.parser;

import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.Expression;
import com.googlecode.aviator.code.CodeGenerator;
import com.googlecode.aviator.exception.ExpressionSyntaxErrorException;
import com.googlecode.aviator.lexer.ExpressionLexer;
import com.googlecode.aviator.lexer.token.CharToken;
import com.googlecode.aviator.lexer.token.PatternToken;
import com.googlecode.aviator.lexer.token.Token;
import com.googlecode.aviator.lexer.token.Variable;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionParser {
    private final ExpressionLexer lexer;
    static final Set<String> RESERVED_WORDS = new HashSet<String>();
    private Token<?> lookhead;
    private Token<?> prevToken;
    private final CodeGenerator codeGenerator;
    private int parenDepth = 0;
    private int bracketDepth = 0;
    private boolean inPattern = false;
    public static final CharToken LEFT_PAREN;
    public static final CharToken RIGHT_PAREN;

    public ExpressionParser(ExpressionLexer lexer, CodeGenerator codeGenerator) {
        this.lexer = lexer;
        this.lookhead = this.lexer.scan();
        if (this.lookhead == null) {
            throw new ExpressionSyntaxErrorException("Blank expression");
        }
        this.codeGenerator = codeGenerator;
    }

    public void ternary() {
        this.join();
        if (this.lookhead == null || this.expectLexeme(":") || this.expectLexeme(",")) {
            return;
        }
        if (this.expectLexeme("?")) {
            this.move(true);
            this.codeGenerator.onTernaryBoolean(this.lookhead);
            this.ternary();
            if (this.expectLexeme(":")) {
                this.move(true);
                this.codeGenerator.onTernaryLeft(this.lookhead);
                this.ternary();
                this.codeGenerator.onTernaryRight(this.lookhead);
            } else {
                this.reportSyntaxError("expect ':'");
            }
        } else {
            if (this.expectLexeme(")")) {
                if (this.parenDepth > 0) {
                    return;
                }
                this.reportSyntaxError("Insert '(' to complete Expression");
            }
            if (this.expectLexeme("]")) {
                if (this.bracketDepth > 0) {
                    return;
                }
                this.reportSyntaxError("Insert '[' to complete Expression");
            }
            if (!this.expectLexeme("(") && !this.expectLexeme("[")) {
                this.reportSyntaxError("illegal expression");
            }
        }
    }

    public void join() {
        this.and();
        while (this.isJoinToken()) {
            this.codeGenerator.onJoinLeft(this.lookhead);
            this.move(true);
            if (this.isJoinToken()) {
                this.move(true);
                this.and();
                this.codeGenerator.onJoinRight(this.lookhead);
                continue;
            }
            this.reportSyntaxError("expect '|'");
        }
        if (this.lookhead != null) {
            // empty if block
        }
    }

    private boolean isJoinToken() {
        return this.expectLexeme("|");
    }

    private boolean expectLexeme(String s) {
        if (this.lookhead == null) {
            return false;
        }
        return this.lookhead.getType() == Token.TokenType.Char && ((CharToken)this.lookhead).getLexeme().equals(s);
    }

    private boolean isAndToken() {
        return this.expectLexeme("&");
    }

    public void bitOr() {
        this.xor();
        while (this.isJoinToken()) {
            this.move(true);
            if (this.isJoinToken()) {
                this.back();
                break;
            }
            this.xor();
            this.codeGenerator.onBitOr(this.lookhead);
        }
    }

    public void xor() {
        this.bitAnd();
        while (this.expectLexeme("^")) {
            this.move(true);
            this.bitAnd();
            this.codeGenerator.onBitXor(this.lookhead);
        }
    }

    public void bitAnd() {
        this.equality();
        while (this.isAndToken()) {
            this.move(true);
            if (this.isAndToken()) {
                this.back();
                break;
            }
            this.equality();
            this.codeGenerator.onBitAnd(this.lookhead);
        }
    }

    public void and() {
        this.bitOr();
        while (this.isAndToken()) {
            this.codeGenerator.onAndLeft(this.lookhead);
            this.move(true);
            if (this.isAndToken()) {
                this.move(true);
                this.bitOr();
                this.codeGenerator.onAndRight(this.lookhead);
                continue;
            }
            this.reportSyntaxError("expect '&'");
        }
    }

    public void equality() {
        this.rel();
        while (true) {
            if (this.expectLexeme("=")) {
                this.move(true);
                if (this.expectLexeme("=")) {
                    this.move(true);
                    this.rel();
                    this.codeGenerator.onEq(this.lookhead);
                    continue;
                }
                if (this.expectLexeme("~")) {
                    this.move(true);
                    this.rel();
                    this.codeGenerator.onMatch(this.lookhead);
                    continue;
                }
                this.reportSyntaxError("Aviator doesn't support assignment");
                continue;
            }
            if (!this.expectLexeme("!")) break;
            this.move(true);
            if (this.expectLexeme("=")) {
                this.move(true);
                this.rel();
                this.codeGenerator.onNeq(this.lookhead);
                continue;
            }
            this.reportSyntaxError("expect '='");
        }
    }

    public void rel() {
        this.shift();
        while (true) {
            if (this.expectLexeme("<")) {
                this.move(true);
                if (this.expectLexeme("=")) {
                    this.move(true);
                    this.expr();
                    this.codeGenerator.onLe(this.lookhead);
                    continue;
                }
                this.expr();
                this.codeGenerator.onLt(this.lookhead);
                continue;
            }
            if (!this.expectLexeme(">")) break;
            this.move(true);
            if (this.expectLexeme("=")) {
                this.move(true);
                this.expr();
                this.codeGenerator.onGe(this.lookhead);
                continue;
            }
            this.expr();
            this.codeGenerator.onGt(this.lookhead);
        }
    }

    public void shift() {
        block4: {
            this.expr();
            while (true) {
                if (this.expectLexeme("<")) {
                    this.move(true);
                    if (this.expectLexeme("<")) {
                        this.move(true);
                        this.expr();
                        this.codeGenerator.onShiftLeft(this.lookhead);
                        continue;
                    }
                    this.back();
                    break block4;
                }
                if (!this.expectLexeme(">")) break block4;
                this.move(true);
                if (!this.expectLexeme(">")) break;
                this.move(true);
                if (this.expectLexeme(">")) {
                    this.move(true);
                    this.expr();
                    this.codeGenerator.onUnsignedShiftRight(this.lookhead);
                    continue;
                }
                this.expr();
                this.codeGenerator.onShiftRight(this.lookhead);
            }
            this.back();
        }
    }

    public void expr() {
        this.term();
        while (true) {
            if (this.expectLexeme("+")) {
                this.move(true);
                this.term();
                this.codeGenerator.onAdd(this.lookhead);
                continue;
            }
            if (!this.expectLexeme("-")) break;
            this.move(true);
            this.term();
            this.codeGenerator.onSub(this.lookhead);
        }
    }

    public void term() {
        this.unary();
        while (true) {
            if (this.expectLexeme("*")) {
                this.move(true);
                this.unary();
                this.codeGenerator.onMult(this.lookhead);
                continue;
            }
            if (this.expectLexeme("/")) {
                this.move(true);
                this.unary();
                this.codeGenerator.onDiv(this.lookhead);
                continue;
            }
            if (!this.expectLexeme("%")) break;
            this.move(true);
            this.unary();
            this.codeGenerator.onMod(this.lookhead);
        }
    }

    public void unary() {
        if (this.expectLexeme("!")) {
            this.move(true);
            if (this.expectLexeme(",") || this.expectLexeme(")")) {
                this.back();
                this.factor();
            } else {
                this.unary();
                this.codeGenerator.onNot(this.lookhead);
            }
        } else if (this.expectLexeme("-")) {
            this.move(true);
            if (this.expectLexeme(",") || this.expectLexeme(")")) {
                this.back();
                this.factor();
            } else {
                this.unary();
                this.codeGenerator.onNeg(this.lookhead);
            }
        } else if (this.expectLexeme("~")) {
            this.move(true);
            if (this.expectLexeme(",") || this.expectLexeme(")")) {
                this.back();
                this.factor();
            } else {
                this.unary();
                this.codeGenerator.onBitNot(this.lookhead);
            }
        } else {
            this.factor();
        }
    }

    public boolean isOPVariable(Token<?> token) {
        if (token.getType() != Token.TokenType.Char) {
            return false;
        }
        CharToken charToken = (CharToken)token;
        this.move(true);
        if (this.expectLexeme(",") || this.expectLexeme(")")) {
            this.back();
            String lexeme = String.valueOf(charToken.getCh());
            if (lexeme.equals("-")) {
                lexeme = "-sub";
            }
            return AviatorEvaluator.containsFunction(lexeme);
        }
        this.back();
        return false;
    }

    public void factor() {
        if (this.lookhead == null) {
            this.reportSyntaxError("invalid value");
        }
        if (this.expectLexeme("(")) {
            ++this.parenDepth;
            this.move(true);
            this.ternary();
            if (!this.expectLexeme(")")) {
                this.reportSyntaxError("insert ')' to complete Expression");
            } else {
                this.move(true);
            }
            --this.parenDepth;
        } else if (this.lookhead.getType() == Token.TokenType.Number || this.lookhead.getType() == Token.TokenType.String || this.lookhead.getType() == Token.TokenType.Variable || this.lookhead == Variable.TRUE || this.lookhead == Variable.FALSE || this.isOPVariable(this.lookhead)) {
            if (this.lookhead.getType() == Token.TokenType.Variable) {
                this.checkVariableName();
            }
            if (this.lookhead.getType() == Token.TokenType.Char) {
                CharToken charToken = (CharToken)this.lookhead;
                this.lookhead = new Variable(charToken.getLexeme(), charToken.getStartIndex());
            }
            this.move(true);
            Token<?> prev = this.prevToken;
            if (prev.getType() == Token.TokenType.Variable && this.expectLexeme("(")) {
                this.method();
            } else if (prev.getType() == Token.TokenType.Variable || prev.getLexeme().equals(")")) {
                boolean hasArray = false;
                while (this.expectLexeme("[")) {
                    if (!hasArray) {
                        this.codeGenerator.onArray(this.prevToken);
                        this.move(true);
                        hasArray = true;
                    } else {
                        this.move(true);
                    }
                    this.codeGenerator.onArrayIndexStart(this.prevToken);
                    this.array();
                }
                if (!hasArray) {
                    this.codeGenerator.onConstant(this.prevToken);
                }
            } else {
                this.codeGenerator.onConstant(prev);
            }
        } else if (this.expectLexeme("/")) {
            this.pattern();
        } else {
            this.reportSyntaxError("invalid value");
        }
    }

    private void array() {
        ++this.bracketDepth;
        if (RESERVED_WORDS.contains(this.prevToken.getLexeme())) {
            throw new ExpressionSyntaxErrorException(this.prevToken.getLexeme() + " could not use [] operator");
        }
        this.ternary();
        if (!this.expectLexeme("]")) {
            this.reportSyntaxError("insert ']' to complete Expression");
        } else {
            --this.bracketDepth;
            this.move(true);
            this.codeGenerator.onArrayIndexEnd(this.lookhead);
        }
    }

    private void checkVariableName() {
        String[] names;
        for (String name : names = this.lookhead.getLexeme().split("\\.")) {
            if (ExpressionParser.isJavaIdentifier(name)) continue;
            this.reportSyntaxError("Illegal identifier " + name + ",index=" + this.lookhead.getStartIndex());
        }
    }

    private void method() {
        ++this.parenDepth;
        this.codeGenerator.onMethodName(this.prevToken);
        this.move(true);
        if (!this.expectLexeme(")")) {
            this.ternary();
            this.codeGenerator.onMethodParameter(this.lookhead);
            while (this.expectLexeme(",")) {
                this.move(true);
                this.ternary();
                this.codeGenerator.onMethodParameter(this.lookhead);
            }
        }
        if (!this.expectLexeme(")")) {
            this.reportSyntaxError("insert ')' to complete expression");
        } else {
            --this.parenDepth;
            this.move(true);
            this.codeGenerator.onMethodInvoke(this.lookhead);
        }
    }

    public static final boolean isJavaIdentifier(String id) {
        if (id == null) {
            return false;
        }
        if (id.equals("")) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(id.charAt(0))) {
            return false;
        }
        for (int i = 1; i < id.length(); ++i) {
            if (Character.isJavaIdentifierPart(id.charAt(i))) continue;
            return false;
        }
        return !id.equals("null");
    }

    private void pattern() {
        int startIndex = this.lookhead.getStartIndex();
        this.move(true);
        this.inPattern = true;
        StringBuffer sb = new StringBuffer();
        while (this.lookhead != null) {
            while (!this.expectLexeme("/")) {
                sb.append(this.lookhead.getLexeme());
                this.move(false);
            }
            if (this.prevToken.getType() == Token.TokenType.Char && ((CharToken)this.prevToken).getLexeme().equals("\\")) {
                sb.append("/");
                this.move(false);
                continue;
            }
            this.inPattern = false;
            break;
        }
        if (this.inPattern) {
            this.reportSyntaxError("invalid regular pattern");
        }
        this.codeGenerator.onConstant(new PatternToken(sb.toString(), startIndex));
        this.move(true);
    }

    private void reportSyntaxError(String message) {
        throw new ExpressionSyntaxErrorException("Syntax error:" + message + " at " + this.lexer.getCurrentIndex());
    }

    public void move(boolean analyse) {
        if (this.lookhead != null) {
            this.prevToken = this.lookhead;
            this.lookhead = this.lexer.scan(analyse);
        } else {
            this.reportSyntaxError("Illegal expression");
        }
    }

    public void back() {
        this.lexer.pushback(this.lookhead);
        this.lookhead = this.prevToken;
    }

    public Expression parse() {
        this.ternary();
        if (this.parenDepth > 0) {
            this.reportSyntaxError("insert ')' to complete Expression");
        }
        if (this.bracketDepth > 0) {
            this.reportSyntaxError("insert ']' to complete Expression");
        }
        return this.codeGenerator.getResult();
    }

    static {
        RESERVED_WORDS.add(Variable.TRUE.getLexeme());
        RESERVED_WORDS.add(Variable.FALSE.getLexeme());
        RESERVED_WORDS.add(Variable.NIL.getLexeme());
        LEFT_PAREN = new CharToken('(', -1);
        RIGHT_PAREN = new CharToken(')', -1);
    }
}

