/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.function.system;

import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.type.AviatorDouble;
import com.googlecode.aviator.runtime.type.AviatorObject;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleFunction
extends AbstractFunction {
    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject arg1) {
        switch (arg1.getAviatorType()) {
            case Boolean: {
                return new AviatorDouble(arg1.booleanValue(env) ? 1 : 0);
            }
            case JavaType: {
                Object obj = arg1.getValue(env);
                if (obj instanceof Number) {
                    return new AviatorDouble(((Number)obj).doubleValue());
                }
                if (obj instanceof String) {
                    return new AviatorDouble(Double.parseDouble((String)obj));
                }
                if (obj instanceof Character) {
                    return new AviatorDouble(Double.parseDouble(String.valueOf(obj)));
                }
                throw new ClassCastException("Could not cast " + obj.getClass().getName() + " to double");
            }
            case String: {
                return new AviatorDouble(Double.parseDouble((String)arg1.getValue(env)));
            }
            case Long: 
            case Double: {
                return new AviatorDouble(((Number)arg1.getValue(env)).doubleValue());
            }
        }
        throw new ClassCastException("Could not cast " + arg1 + " to double");
    }

    @Override
    public String getName() {
        return "double";
    }
}

