/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.security;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtUtils {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JwtUtils.class);
    private static final Pattern JWT_EXPIRATION_PATTERN = Pattern.compile("\"exp\":\\s?(\\d+)");

    public static Long extractExpirationTime(String jsonWebToken) {
        if (jsonWebToken == null || jsonWebToken.trim().equals("")) {
            return null;
        }
        String[] tokenParts = jsonWebToken.split("\\.");
        if (tokenParts == null || tokenParts.length != 3) {
            return null;
        }
        String encodedBody = tokenParts[1];
        String decodedJsonBody = new String(Base64.getDecoder().decode(encodedBody));
        return JwtUtils.parseExpirationTime(decodedJsonBody);
    }

    @VisibleForTesting
    static Long parseExpirationTime(String jwtBody) {
        String matchedString;
        String[] expiryTimeFieldParts;
        Matcher matcher;
        Long result = null;
        if (jwtBody != null && !jwtBody.trim().equals("") && (matcher = JWT_EXPIRATION_PATTERN.matcher(jwtBody)).find() && (expiryTimeFieldParts = (matchedString = matcher.group()).split(":")) != null && expiryTimeFieldParts.length == 2) {
            result = Long.parseLong(expiryTimeFieldParts[1].trim());
        }
        return result;
    }
}

