/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.util;

import java.util.EnumSet;

public enum JvmType {
    UNKNOWN(null),
    IBM("J9"),
    OPENJDK("OpenJDK"),
    ORACLE("HotSpot");

    private final String inclusiveString;
    private static final EnumSet<JvmType> JVM_TYPE;

    private JvmType(String inclusiveString) {
        this.inclusiveString = inclusiveString;
    }

    public static JvmType fromVendor(String vendorName) {
        if (vendorName == null) {
            return UNKNOWN;
        }
        String vendorNameTrimmed = vendorName.trim();
        for (JvmType jvmType : JVM_TYPE) {
            if (!jvmType.toString().equalsIgnoreCase(vendorNameTrimmed)) continue;
            return jvmType;
        }
        return UNKNOWN;
    }

    public static JvmType fromVmName(String vmName) {
        if (vmName == null) {
            return UNKNOWN;
        }
        for (JvmType jvmType : JVM_TYPE) {
            if (jvmType.inclusiveString == null || !vmName.contains(jvmType.inclusiveString)) continue;
            return jvmType;
        }
        return UNKNOWN;
    }

    static {
        JVM_TYPE = EnumSet.allOf(JvmType.class);
    }
}

