/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap;

import com.navercorp.pinpoint.bootstrap.BootStrapException;
import java.util.concurrent.Callable;

public class ContextClassLoaderExecuteTemplate<V> {
    private final ClassLoader classLoader;

    public ContextClassLoaderExecuteTemplate(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public V execute(Callable<V> callable) throws BootStrapException {
        try {
            Thread currentThread = Thread.currentThread();
            ClassLoader before = currentThread.getContextClassLoader();
            currentThread.setContextClassLoader(this.classLoader);
            try {
                V v = callable.call();
                return v;
            }
            finally {
                currentThread.setContextClassLoader(before);
            }
        }
        catch (BootStrapException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BootStrapException("execute fail. Error:" + ex.getMessage(), ex);
        }
    }
}

