/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.trace.api;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.SpanProcessor;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.eventmesh.trace.api.EventMeshTraceService;
import org.apache.eventmesh.trace.api.config.ExporterConfiguration;
import org.apache.eventmesh.trace.api.exception.TraceException;

public abstract class AbstractTraceService
implements EventMeshTraceService {
    protected transient SdkTracerProvider sdkTracerProvider;
    protected transient Tracer tracer;
    protected transient TextMapPropagator textMapPropagator;
    protected transient ExporterConfiguration exporterConfiguration;
    protected transient Thread shutdownHook;

    @Override
    public Context extractFrom(Context context, Map<String, Object> carrier) throws TraceException {
        this.textMapPropagator.extract(context, carrier, (TextMapGetter)new TextMapGetter<Map<String, Object>>(){

            public Iterable<String> keys(@Nonnull Map<String, Object> carrier) {
                return carrier.keySet();
            }

            @Nullable
            public String get(@Nonnull Map<String, Object> carrier, String key) {
                return Optional.ofNullable(carrier.get(key)).map(Objects::toString).orElse(null);
            }
        });
        return context;
    }

    @Override
    public void inject(Context context, Map<String, Object> map) {
        this.textMapPropagator.inject(context, map, (carrier, key, value) -> map.put(key, value));
    }

    @Override
    public Span createSpan(String spanName, SpanKind spanKind, long startTimestamp, TimeUnit timeUnit, Context context, boolean isSpanFinishInOtherThread) throws TraceException {
        return this.tracer.spanBuilder(spanName).setParent(context).setSpanKind(spanKind).setStartTimestamp(startTimestamp, timeUnit).startSpan();
    }

    @Override
    public Span createSpan(String spanName, SpanKind spanKind, Context context, boolean isSpanFinishInOtherThread) throws TraceException {
        return this.tracer.spanBuilder(spanName).setParent(context).setSpanKind(spanKind).setStartTimestamp(System.currentTimeMillis(), TimeUnit.MILLISECONDS).startSpan();
    }

    @Override
    public void shutdown() throws TraceException {
        try {
            if (this.sdkTracerProvider != null) {
                this.sdkTracerProvider.close();
            }
        }
        catch (Exception e) {
            throw new TraceException("trace close error", e);
        }
    }

    protected void initVars(SpanProcessor spanProcessor, Resource serviceNameResource) {
        SdkTracerProviderBuilder builder = SdkTracerProvider.builder().addSpanProcessor(spanProcessor);
        if (serviceNameResource != null) {
            builder.setResource(Resource.getDefault().merge(serviceNameResource));
        }
        this.sdkTracerProvider = builder.build();
        OpenTelemetrySdk openTelemetry = OpenTelemetrySdk.builder().setPropagators(ContextPropagators.create((TextMapPropagator)W3CTraceContextPropagator.getInstance())).setTracerProvider(this.sdkTracerProvider).build();
        this.tracer = openTelemetry.getTracer("eventmesh_trace");
        this.textMapPropagator = openTelemetry.getPropagators().getTextMapPropagator();
        this.shutdownHook = new Thread(() -> ((SdkTracerProvider)this.sdkTracerProvider).close());
        this.shutdownHook.setDaemon(true);
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    @Generated
    public SdkTracerProvider getSdkTracerProvider() {
        return this.sdkTracerProvider;
    }

    @Generated
    public Tracer getTracer() {
        return this.tracer;
    }

    @Generated
    public TextMapPropagator getTextMapPropagator() {
        return this.textMapPropagator;
    }

    @Generated
    public ExporterConfiguration getExporterConfiguration() {
        return this.exporterConfiguration;
    }

    @Generated
    public Thread getShutdownHook() {
        return this.shutdownHook;
    }

    @Generated
    public void setSdkTracerProvider(SdkTracerProvider sdkTracerProvider) {
        this.sdkTracerProvider = sdkTracerProvider;
    }

    @Generated
    public void setTracer(Tracer tracer) {
        this.tracer = tracer;
    }

    @Generated
    public void setTextMapPropagator(TextMapPropagator textMapPropagator) {
        this.textMapPropagator = textMapPropagator;
    }

    @Generated
    public void setExporterConfiguration(ExporterConfiguration exporterConfiguration) {
        this.exporterConfiguration = exporterConfiguration;
    }

    @Generated
    public void setShutdownHook(Thread shutdownHook) {
        this.shutdownHook = shutdownHook;
    }
}

