/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import lombok.Generated;

public final class NameUtils {
    public static final String INTERNAL_NAME_PREFIX = "_";
    public static final String SEPARATOR = ".#.";
    public static final String INTERNAL_SCOPE_NAME = "_system";
    public static final String INTERNAL_SCOPE_PREFIX = "_system/";
    public static final String INTERNAL_CONTAINER_PREFIX = "_system/containers/";
    public static final String READER_GROUP_STREAM_PREFIX = "_RG";
    public static final String METADATA_TABLE = "metadata.#.%s";
    public static final String EPOCHS_WITH_TRANSACTIONS_TABLE = "epochsWithTransactions.#.%s";
    public static final String TRANSACTIONS_IN_EPOCH_TABLE_FORMAT = "transactionsInEpoch-%s.#.%s";
    public static final String WRITERS_POSITIONS_TABLE = "writersPositions.#.%s";
    public static final String COMPLETED_TRANSACTIONS_BATCHES_TABLE = NameUtils.getQualifiedTableName("_system", "completedTransactionsBatches");
    public static final String COMPLETED_TRANSACTIONS_BATCH_TABLE_FORMAT = "completedTransactionsBatch-%s";
    public static final String DELETED_STREAMS_TABLE = NameUtils.getQualifiedTableName("_system", "deletedStreams");
    public static final int MAX_PREFIX_OR_SUFFIX_SIZE = 5;
    public static final int MAX_NAME_SIZE = 255;
    public static final int MAX_GIVEN_NAME_SIZE = 250;
    public static final String CREATION_TIME_KEY = "creationTime";
    public static final String CONFIGURATION_KEY = "configuration";
    public static final String TRUNCATION_KEY = "truncation";
    public static final String STATE_KEY = "state";
    public static final String EPOCH_TRANSITION_KEY = "epochTransition";
    public static final String RETENTION_SET_KEY = "retention";
    public static final String RETENTION_STREAM_CUT_RECORD_KEY_FORMAT = "retentionCuts-%s";
    public static final String CURRENT_EPOCH_KEY = "currentEpochRecord";
    public static final String EPOCH_RECORD_KEY_FORMAT = "epochRecord-%s";
    public static final String HISTORY_TIMESERIES_CHUNK_FORMAT = "historyTimeSeriesChunk-%s";
    public static final String SEGMENTS_SEALED_SIZE_MAP_SHARD_FORMAT = "segmentsSealedSizeMapShard-%s";
    public static final String SEGMENT_SEALED_EPOCH_KEY_FORMAT = "segmentSealedEpochPath-%s";
    public static final String COMMITTING_TRANSACTIONS_RECORD_KEY = "committingTxns";
    public static final String SEGMENT_MARKER_PATH_FORMAT = "markers-%d";
    public static final String WAITING_REQUEST_PROCESSOR_PATH = "waitingRequestProcessor";
    public static final String SUBSCRIBER_KEY_PREFIX = "subscriber_";
    public static final String SUBSCRIBER_SET_KEY = "subscriberset";
    static final String TAG_SCOPE = "scope";
    static final String TAG_STREAM = "stream";
    static final String TAG_SEGMENT = "segment";
    static final String TAG_EPOCH = "epoch";
    static final String TAG_DEFAULT = "default";
    static final String TAG_WRITER = "writer";
    private static final String ATTRIBUTE_SUFFIX = "$attributes.index";
    private static final String HEADER_SUFFIX = "$header";
    private static final String OFFSET_SUFFIX = "$offset.";
    private static final String TRANSACTION_DELIMITER = "#transaction.";
    private static final String TRANSIENT_DELIMITER = "#transient.";
    private static final String EPOCH_DELIMITER = ".#epoch.";
    private static final String CHUNK_NAME_FORMAT_WITH_EPOCH_OFFSET = "%s.E-%d-O-%d.%s";
    private static final String BLOCK_INDEX_NAME_FORMAT_WITH_OFFSET = "%s.B-%d";
    private static final String METADATA_SEGMENT_NAME_PREFIX = "_system/containers/metadata_";
    private static final String METADATA_SEGMENT_NAME_FORMAT = "_system/containers/metadata_%d";
    private static final String STORAGE_METADATA_SEGMENT_NAME_PREFIX = "_system/containers/storage_metadata_";
    private static final String STORAGE_METADATA_SEGMENT_NAME_FORMAT = "_system/containers/storage_metadata_%d";
    private static final String SYSJOURNAL_NAME_FORMAT = "_system/containers/_sysjournal.epoch%d.container%d.file%d";
    private static final String SYSJOURNAL_SNAPSHOT_NAME_FORMAT = "_system/containers/_sysjournal.epoch%d.container%d.snapshot%d";
    private static final int TRANSACTION_PART_LENGTH = 16;
    private static final int TRANSIENT_PART_LENGTH = 16;
    private static final int TRANSACTION_ID_LENGTH = 32;
    private static final int TRANSIENT_ID_LENGTH = 32;
    private static final String FULL_HEX_FORMAT = "%016x";
    private static final String TABLES = "_tables";
    private static final String KVTABLE_SUFFIX = "_kvtable";
    private static final String MARK_PREFIX = "_MARK";
    private static final String CONTAINER_EVENT_PROCESSOR_SEGMENT_NAME = "_system/containers/event_processor_%s_%d";

    public static String getTransactionNameFromId(String parentStreamSegmentName, UUID transactionId) {
        StringBuilder result = new StringBuilder();
        result.append(parentStreamSegmentName);
        result.append(TRANSACTION_DELIMITER);
        result.append(String.format(FULL_HEX_FORMAT, transactionId.getMostSignificantBits()));
        result.append(String.format(FULL_HEX_FORMAT, transactionId.getLeastSignificantBits()));
        return result.toString();
    }

    public static String getTransientNameFromId(String parentStreamSegmentName, UUID writerId) {
        UUID random = UUID.randomUUID();
        StringBuilder result = new StringBuilder();
        result.append(parentStreamSegmentName);
        result.append(TRANSIENT_DELIMITER);
        result.append(String.format(FULL_HEX_FORMAT, writerId.getMostSignificantBits()));
        result.append(String.format(FULL_HEX_FORMAT, writerId.getLeastSignificantBits()));
        result.append('.');
        result.append(String.format(FULL_HEX_FORMAT, random.getMostSignificantBits()));
        result.append(String.format(FULL_HEX_FORMAT, random.getLeastSignificantBits()));
        return result.toString();
    }

    private static int getDelimiterPosition(String streamSegmentName, String delimiter, int idLength) {
        int endOfStreamNamePos = streamSegmentName.lastIndexOf(delimiter);
        if (endOfStreamNamePos < 0 || endOfStreamNamePos + delimiter.length() + idLength > streamSegmentName.length()) {
            return -1;
        }
        return endOfStreamNamePos;
    }

    public static String getParentStreamSegmentName(String segmentName) {
        int endOfTransactionStream = NameUtils.getDelimiterPosition(segmentName, TRANSACTION_DELIMITER, 32);
        if (endOfTransactionStream >= 0) {
            return segmentName.substring(0, endOfTransactionStream);
        }
        int endOfTransientStream = NameUtils.getDelimiterPosition(segmentName, TRANSIENT_DELIMITER, 32);
        if (endOfTransientStream >= 0) {
            return segmentName.substring(0, endOfTransientStream);
        }
        return null;
    }

    public static boolean isTransactionSegment(String streamSegmentName) {
        return NameUtils.getDelimiterPosition(streamSegmentName, TRANSACTION_DELIMITER, 32) >= 0;
    }

    public static boolean isTransientSegment(String streamSegmentName) {
        return NameUtils.getDelimiterPosition(streamSegmentName, TRANSIENT_DELIMITER, 32) >= 0;
    }

    public static String extractPrimaryStreamSegmentName(String streamSegmentName) {
        if (NameUtils.isTransactionSegment(streamSegmentName) || NameUtils.isTransientSegment(streamSegmentName)) {
            return NameUtils.extractPrimaryStreamSegmentName(NameUtils.getParentStreamSegmentName(streamSegmentName));
        }
        int endOfStreamNamePos = streamSegmentName.lastIndexOf(EPOCH_DELIMITER);
        if (endOfStreamNamePos < 0) {
            return streamSegmentName;
        }
        return streamSegmentName.substring(0, endOfStreamNamePos);
    }

    public static boolean isAttributeSegment(String segmentName) {
        return segmentName.endsWith(ATTRIBUTE_SUFFIX);
    }

    public static String getAttributeSegmentName(String segmentName) {
        Preconditions.checkArgument((!NameUtils.isAttributeSegment(segmentName) ? 1 : 0) != 0, (Object)"segmentName is already an attribute segment name");
        return segmentName + ATTRIBUTE_SUFFIX;
    }

    public static String getHeaderSegmentName(String segmentName) {
        Preconditions.checkArgument((!segmentName.endsWith(HEADER_SUFFIX) ? 1 : 0) != 0, (Object)"segmentName is already a segment header name");
        return segmentName + HEADER_SUFFIX;
    }

    public static boolean isHeaderSegment(String segmentName) {
        return segmentName.endsWith(HEADER_SUFFIX);
    }

    public static String getSegmentNameFromHeader(String headerSegmentName) {
        Preconditions.checkArgument((boolean)headerSegmentName.endsWith(HEADER_SUFFIX));
        return headerSegmentName.substring(0, headerSegmentName.length() - HEADER_SUFFIX.length());
    }

    public static String getSegmentChunkName(String segmentName, long offset) {
        Preconditions.checkArgument((!segmentName.contains(OFFSET_SUFFIX) ? 1 : 0) != 0, (Object)"segmentName is already a SegmentChunk name");
        return segmentName + OFFSET_SUFFIX + offset;
    }

    public static String getSegmentChunkName(String segmentName, long epoch, long offset) {
        return String.format(CHUNK_NAME_FORMAT_WITH_EPOCH_OFFSET, segmentName, epoch, offset, UUID.randomUUID());
    }

    public static String getSegmentReadIndexBlockName(String segmentName, long offset) {
        return String.format(BLOCK_INDEX_NAME_FORMAT_WITH_OFFSET, segmentName, offset);
    }

    public static boolean isMetadataSegmentName(String segmentName) {
        return segmentName.startsWith(METADATA_SEGMENT_NAME_PREFIX);
    }

    public static String getMetadataSegmentName(int containerId) {
        Preconditions.checkArgument((containerId >= 0 ? 1 : 0) != 0, (Object)"containerId must be a non-negative number.");
        return String.format(METADATA_SEGMENT_NAME_FORMAT, containerId);
    }

    public static boolean isStorageMetadataSegmentName(String segmentName) {
        return segmentName.startsWith(STORAGE_METADATA_SEGMENT_NAME_PREFIX);
    }

    public static String getStorageMetadataSegmentName(int containerId) {
        Preconditions.checkArgument((containerId >= 0 ? 1 : 0) != 0, (Object)"containerId must be a non-negative number.");
        return String.format(STORAGE_METADATA_SEGMENT_NAME_FORMAT, containerId);
    }

    public static String getSystemJournalFileName(int containerId, long epoch, long currentFileIndex) {
        return String.format(SYSJOURNAL_NAME_FORMAT, epoch, containerId, currentFileIndex);
    }

    public static String getSystemJournalSnapshotFileName(int containerId, long epoch, long currentSnapshotIndex) {
        return String.format(SYSJOURNAL_SNAPSHOT_NAME_FORMAT, epoch, containerId, currentSnapshotIndex);
    }

    public static long computeSegmentId(int segmentNumber, int epoch) {
        Preconditions.checkArgument((segmentNumber >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((epoch >= 0 ? 1 : 0) != 0);
        return (long)epoch << 32 | (long)segmentNumber & 0xFFFFFFFFL;
    }

    public static int getSegmentNumber(long segmentId) {
        return (int)segmentId;
    }

    public static int getEpoch(long segmentId) {
        return (int)(segmentId >> 32);
    }

    public static int getEpoch(UUID txnId) {
        return (int)(txnId.getMostSignificantBits() >> 32);
    }

    public static String getScopedStreamName(String scope, String streamName) {
        return NameUtils.getScopedStreamNameInternal(scope, streamName).toString();
    }

    public static String getScopedKeyValueTableName(String scope, String streamName) {
        return NameUtils.getScopedStreamNameInternal(scope, streamName).toString();
    }

    public static String getScopedReaderGroupName(String scope, String rgName) {
        return NameUtils.getScopedStreamNameInternal(scope, rgName).toString();
    }

    public static String getQualifiedTableSegmentName(String scope, String kvTableName, long segmentId) {
        int segmentNumber = NameUtils.getSegmentNumber(segmentId);
        int epoch = NameUtils.getEpoch(segmentId);
        StringBuilder sb = NameUtils.getScopedStreamNameInternal(scope, kvTableName + KVTABLE_SUFFIX);
        sb.append('/');
        sb.append(segmentNumber);
        sb.append(EPOCH_DELIMITER);
        sb.append(epoch);
        return sb.toString();
    }

    public static List<String> extractScopedNameTokens(String scopedName) {
        String[] tokens = scopedName.split("/");
        Preconditions.checkArgument((tokens.length == 2 ? 1 : 0) != 0, (String)"Unexpected format for '%s'. Expected format '<scope-name>/<name>'.", (Object)scopedName);
        return Arrays.asList(tokens);
    }

    public static String getQualifiedStreamSegmentName(String scope, String streamName, long segmentId) {
        int segmentNumber = NameUtils.getSegmentNumber(segmentId);
        int epoch = NameUtils.getEpoch(segmentId);
        StringBuilder sb = NameUtils.getScopedStreamNameInternal(scope, streamName);
        sb.append('/');
        sb.append(segmentNumber);
        sb.append(EPOCH_DELIMITER);
        sb.append(epoch);
        return sb.toString();
    }

    public static List<String> extractSegmentTokens(String qualifiedName) {
        long segmentId;
        int segmentIdIndex;
        Preconditions.checkNotNull((Object)qualifiedName);
        String originalSegmentName = NameUtils.isTransactionSegment(qualifiedName) ? NameUtils.getParentStreamSegmentName(qualifiedName) : qualifiedName;
        LinkedList<String> retVal = new LinkedList<String>();
        String[] tokens = originalSegmentName.split("/");
        int n = segmentIdIndex = tokens.length == 2 ? 1 : 2;
        if (tokens[segmentIdIndex].contains(EPOCH_DELIMITER)) {
            String[] segmentIdTokens = tokens[segmentIdIndex].split(EPOCH_DELIMITER);
            segmentId = NameUtils.computeSegmentId(Integer.parseInt(segmentIdTokens[0]), Integer.parseInt(segmentIdTokens[1]));
        } else {
            segmentId = NameUtils.computeSegmentId(Integer.parseInt(tokens[segmentIdIndex]), 0);
        }
        retVal.add(tokens[0]);
        if (tokens.length == 3) {
            retVal.add(tokens[1]);
        }
        retVal.add(Long.toString(segmentId));
        return retVal;
    }

    private static StringBuilder getScopedStreamNameInternal(String scope, String streamName) {
        StringBuilder sb = new StringBuilder();
        if (!Strings.isNullOrEmpty((String)scope)) {
            sb.append(scope);
            sb.append('/');
        }
        sb.append(streamName);
        return sb;
    }

    public static String getQualifiedTableName(String scope, String ... tokens) {
        Preconditions.checkArgument((tokens != null && tokens.length > 0 ? 1 : 0) != 0);
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%s/%s", scope, TABLES));
        for (String token : tokens) {
            sb.append('/');
            sb.append(token);
        }
        return sb.toString();
    }

    public static List<String> extractTableSegmentTokens(String qualifiedName) {
        Preconditions.checkNotNull((Object)qualifiedName);
        LinkedList<String> retVal = new LinkedList<String>();
        String[] tokens = qualifiedName.split("/");
        Preconditions.checkArgument((tokens.length > 2 ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)tokens[1].equals(TABLES));
        retVal.add(tokens[0]);
        for (int i = 2; i < tokens.length; ++i) {
            retVal.add(tokens[i]);
        }
        return retVal;
    }

    public static boolean isTableSegment(String qualifiedName) {
        Preconditions.checkNotNull((Object)qualifiedName);
        String[] tokens = qualifiedName.split("/");
        Preconditions.checkArgument((tokens.length > 2 ? 1 : 0) != 0);
        return tokens[1].equals(TABLES);
    }

    public static String[] segmentTags(String qualifiedSegmentName) {
        Preconditions.checkNotNull((Object)qualifiedSegmentName);
        String[] tags = new String[]{TAG_SCOPE, null, TAG_STREAM, null, TAG_SEGMENT, null, TAG_EPOCH, null};
        return NameUtils.updateSegmentTags(qualifiedSegmentName, tags);
    }

    public static String[] segmentTags(String qualifiedSegmentName, String writerId) {
        Preconditions.checkNotNull((Object)qualifiedSegmentName);
        Exceptions.checkNotNullOrEmpty((String)writerId, (String)"writerId");
        String[] tags = new String[]{TAG_SCOPE, null, TAG_STREAM, null, TAG_SEGMENT, null, TAG_EPOCH, null, TAG_WRITER, null};
        NameUtils.updateSegmentTags(qualifiedSegmentName, tags);
        tags[9] = writerId;
        return tags;
    }

    private static String[] updateSegmentTags(String qualifiedSegmentName, String[] tags) {
        int segmentIdIndex;
        String segmentBaseName = NameUtils.getSegmentBaseName(qualifiedSegmentName);
        String[] tokens = segmentBaseName.split("/");
        int n = tokens.length == 1 ? 0 : (segmentIdIndex = tokens.length == 2 ? 1 : 2);
        if (tokens[segmentIdIndex].contains(EPOCH_DELIMITER)) {
            String[] segmentIdTokens = tokens[segmentIdIndex].split(EPOCH_DELIMITER);
            tags[5] = segmentIdTokens[0];
            tags[7] = segmentIdTokens[1];
        } else {
            tags[5] = tokens[segmentIdIndex];
            tags[7] = "0";
        }
        if (tokens.length == 3) {
            tags[1] = tokens[0];
            tags[3] = tokens[1];
        } else if (tokens.length == 1) {
            tags[1] = TAG_DEFAULT;
            tags[3] = TAG_DEFAULT;
        } else {
            tags[1] = TAG_DEFAULT;
            tags[3] = tokens[0];
        }
        return tags;
    }

    public static String[] writerTags(String writerId) {
        Exceptions.checkNotNullOrEmpty((String)writerId, (String)"writerId");
        return new String[]{TAG_WRITER, writerId};
    }

    private static String getSegmentBaseName(String segmentQualifiedName) {
        String segmentBaseName = NameUtils.getParentStreamSegmentName(segmentQualifiedName);
        return segmentBaseName == null ? segmentQualifiedName : segmentBaseName;
    }

    public static String getEventProcessorSegmentName(int containerId, String processorName) {
        return String.format(CONTAINER_EVENT_PROCESSOR_SEGMENT_NAME, processorName, containerId);
    }

    public static String getInternalNameForStream(String streamName) {
        return INTERNAL_NAME_PREFIX + streamName;
    }

    public static String getStreamForReaderGroup(String groupNameName) {
        return READER_GROUP_STREAM_PREFIX + groupNameName;
    }

    public static String validateUserStreamName(String name) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkArgument((name.length() <= 250 ? 1 : 0) != 0, (String)"Name cannot exceed %s characters", (int)250);
        Preconditions.checkArgument((boolean)name.matches("[\\p{Alnum}\\.\\-]+"), (Object)"Name must be a-z, 0-9, ., -.");
        return name;
    }

    public static String validateUserKeyValueTableName(String name) {
        return NameUtils.validateUserStreamName(name);
    }

    public static String validateStreamName(String name) {
        Preconditions.checkNotNull((Object)name);
        String matcher = "[_]?[\\p{Alnum}\\.\\-]+";
        Preconditions.checkArgument((name.length() <= 255 ? 1 : 0) != 0, (String)"Name cannot exceed %s characters", (int)255);
        Preconditions.checkArgument((boolean)name.matches("[_]?[\\p{Alnum}\\.\\-]+"), (Object)"Name must be [_]?[\\p{Alnum}\\.\\-]+");
        return name;
    }

    public static String validateUserScopeName(String name) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkArgument((name.length() <= 255 ? 1 : 0) != 0, (String)"Name cannot exceed %s characters", (int)255);
        Preconditions.checkArgument((boolean)name.matches("[\\p{Alnum}\\.\\-]+"), (Object)"Name must be a-z, 0-9, ., -.");
        return name;
    }

    public static String validateScopeName(String name) {
        return NameUtils.validateStreamName(name);
    }

    public static String validateReaderGroupName(String name) {
        return NameUtils.validateUserStreamName(name);
    }

    public static String validateReaderId(String readerId) {
        return NameUtils.validateUserStreamName(readerId);
    }

    public static String validateWriterId(String writerId) {
        return NameUtils.validateUserStreamName(writerId);
    }

    public static String getMarkStreamForStream(String stream) {
        StringBuilder sb = new StringBuilder();
        sb.append(MARK_PREFIX);
        sb.append(stream);
        return sb.toString();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static String getMARK_PREFIX() {
        return MARK_PREFIX;
    }
}

