/*
 * Decompiled with CFR 0.152.
 */
package com.theokanning.openai.fine_tuning;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.theokanning.openai.fine_tuning.Hyperparameters;
import lombok.NonNull;

public class FineTuningJobRequest {
    @JsonProperty(value="training_file")
    @NonNull
    String trainingFile;
    @JsonProperty(value="validation_file")
    String validationFile;
    @NonNull
    String model;
    Hyperparameters hyperparameters;
    String suffix;

    public static FineTuningJobRequestBuilder builder() {
        return new FineTuningJobRequestBuilder();
    }

    public FineTuningJobRequest() {
    }

    public FineTuningJobRequest(@NonNull String trainingFile, String validationFile, @NonNull String model, Hyperparameters hyperparameters, String suffix) {
        if (trainingFile == null) {
            throw new NullPointerException("trainingFile is marked non-null but is null");
        }
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        this.trainingFile = trainingFile;
        this.validationFile = validationFile;
        this.model = model;
        this.hyperparameters = hyperparameters;
        this.suffix = suffix;
    }

    @NonNull
    public String getTrainingFile() {
        return this.trainingFile;
    }

    public String getValidationFile() {
        return this.validationFile;
    }

    @NonNull
    public String getModel() {
        return this.model;
    }

    public Hyperparameters getHyperparameters() {
        return this.hyperparameters;
    }

    public String getSuffix() {
        return this.suffix;
    }

    @JsonProperty(value="training_file")
    public void setTrainingFile(@NonNull String trainingFile) {
        if (trainingFile == null) {
            throw new NullPointerException("trainingFile is marked non-null but is null");
        }
        this.trainingFile = trainingFile;
    }

    @JsonProperty(value="validation_file")
    public void setValidationFile(String validationFile) {
        this.validationFile = validationFile;
    }

    public void setModel(@NonNull String model) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        this.model = model;
    }

    public void setHyperparameters(Hyperparameters hyperparameters) {
        this.hyperparameters = hyperparameters;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FineTuningJobRequest)) {
            return false;
        }
        FineTuningJobRequest other = (FineTuningJobRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$trainingFile = this.getTrainingFile();
        String other$trainingFile = other.getTrainingFile();
        if (this$trainingFile == null ? other$trainingFile != null : !this$trainingFile.equals(other$trainingFile)) {
            return false;
        }
        String this$validationFile = this.getValidationFile();
        String other$validationFile = other.getValidationFile();
        if (this$validationFile == null ? other$validationFile != null : !this$validationFile.equals(other$validationFile)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        Hyperparameters this$hyperparameters = this.getHyperparameters();
        Hyperparameters other$hyperparameters = other.getHyperparameters();
        if (this$hyperparameters == null ? other$hyperparameters != null : !((Object)this$hyperparameters).equals(other$hyperparameters)) {
            return false;
        }
        String this$suffix = this.getSuffix();
        String other$suffix = other.getSuffix();
        return !(this$suffix == null ? other$suffix != null : !this$suffix.equals(other$suffix));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FineTuningJobRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $trainingFile = this.getTrainingFile();
        result = result * 59 + ($trainingFile == null ? 43 : $trainingFile.hashCode());
        String $validationFile = this.getValidationFile();
        result = result * 59 + ($validationFile == null ? 43 : $validationFile.hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        Hyperparameters $hyperparameters = this.getHyperparameters();
        result = result * 59 + ($hyperparameters == null ? 43 : ((Object)$hyperparameters).hashCode());
        String $suffix = this.getSuffix();
        result = result * 59 + ($suffix == null ? 43 : $suffix.hashCode());
        return result;
    }

    public String toString() {
        return "FineTuningJobRequest(trainingFile=" + this.getTrainingFile() + ", validationFile=" + this.getValidationFile() + ", model=" + this.getModel() + ", hyperparameters=" + this.getHyperparameters() + ", suffix=" + this.getSuffix() + ")";
    }

    public static class FineTuningJobRequestBuilder {
        private String trainingFile;
        private String validationFile;
        private String model;
        private Hyperparameters hyperparameters;
        private String suffix;

        FineTuningJobRequestBuilder() {
        }

        @JsonProperty(value="training_file")
        public FineTuningJobRequestBuilder trainingFile(@NonNull String trainingFile) {
            if (trainingFile == null) {
                throw new NullPointerException("trainingFile is marked non-null but is null");
            }
            this.trainingFile = trainingFile;
            return this;
        }

        @JsonProperty(value="validation_file")
        public FineTuningJobRequestBuilder validationFile(String validationFile) {
            this.validationFile = validationFile;
            return this;
        }

        public FineTuningJobRequestBuilder model(@NonNull String model) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            this.model = model;
            return this;
        }

        public FineTuningJobRequestBuilder hyperparameters(Hyperparameters hyperparameters) {
            this.hyperparameters = hyperparameters;
            return this;
        }

        public FineTuningJobRequestBuilder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public FineTuningJobRequest build() {
            return new FineTuningJobRequest(this.trainingFile, this.validationFile, this.model, this.hyperparameters, this.suffix);
        }

        public String toString() {
            return "FineTuningJobRequest.FineTuningJobRequestBuilder(trainingFile=" + this.trainingFile + ", validationFile=" + this.validationFile + ", model=" + this.model + ", hyperparameters=" + this.hyperparameters + ", suffix=" + this.suffix + ")";
        }
    }
}

