/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.grpc.consumer;

import io.grpc.stub.StreamObserver;
import java.io.Serializable;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import lombok.Generated;
import org.apache.eventmesh.client.grpc.config.EventMeshGrpcClientConfig;
import org.apache.eventmesh.client.grpc.consumer.ReceiveMsgHook;
import org.apache.eventmesh.client.grpc.util.EventMeshCloudEventBuilder;
import org.apache.eventmesh.common.enums.EventMeshDataContentType;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEvent;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.ConsumerServiceGrpc;
import org.apache.eventmesh.common.protocol.grpc.common.EventMeshCloudEventUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubStreamHandler<T>
extends Thread
implements Serializable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SubStreamHandler.class);
    private final transient CountDownLatch latch = new CountDownLatch(1);
    private final transient ConsumerServiceGrpc.ConsumerServiceStub consumerAsyncClient;
    private final transient EventMeshGrpcClientConfig clientConfig;
    private transient StreamObserver<CloudEvent> sender;
    private final ReceiveMsgHook<T> listener;

    public SubStreamHandler(ConsumerServiceGrpc.ConsumerServiceStub consumerAsyncClient, EventMeshGrpcClientConfig clientConfig, ReceiveMsgHook<T> listener) {
        this.consumerAsyncClient = consumerAsyncClient;
        this.clientConfig = clientConfig;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendSubscription(CloudEvent subscription) {
        SubStreamHandler subStreamHandler = this;
        synchronized (subStreamHandler) {
            if (this.sender == null) {
                this.sender = this.consumerAsyncClient.subscribeStream(this.createReceiver());
            }
        }
        this.senderOnNext(subscription);
    }

    private StreamObserver<CloudEvent> createReceiver() {
        return new StreamObserver<CloudEvent>(){

            public void onNext(CloudEvent message) {
                Object msg = EventMeshCloudEventBuilder.buildMessageFromEventMeshCloudEvent(message, SubStreamHandler.this.listener.getProtocolType());
                if (msg instanceof Set) {
                    log.info("Received message from Server:{}", (Object)message);
                } else {
                    log.info("Received message from Server.|seq={}|uniqueId={}|", (Object)EventMeshCloudEventUtils.getSeqNum((CloudEvent)message), (Object)EventMeshCloudEventUtils.getUniqueId((CloudEvent)message));
                    CloudEvent streamReply = null;
                    try {
                        Optional reply = SubStreamHandler.this.listener.handle(msg);
                        if (reply.isPresent()) {
                            streamReply = SubStreamHandler.this.buildReplyMessage(message, reply.get());
                        }
                    }
                    catch (Exception e) {
                        log.error("Error in handling reply message.|seq={}|uniqueId={}|", new Object[]{EventMeshCloudEventUtils.getSeqNum((CloudEvent)message), EventMeshCloudEventUtils.getUniqueId((CloudEvent)message), e});
                    }
                    if (streamReply != null) {
                        log.info("Sending reply message to Server.|seq={}|uniqueId={}|", (Object)EventMeshCloudEventUtils.getSeqNum((CloudEvent)streamReply), (Object)EventMeshCloudEventUtils.getUniqueId((CloudEvent)streamReply));
                        SubStreamHandler.this.senderOnNext(streamReply);
                    }
                }
            }

            public void onError(Throwable t) {
                log.error("Received Server side error", t);
                SubStreamHandler.this.close();
            }

            public void onCompleted() {
                log.info("Finished receiving messages from server.");
            }
        };
    }

    private CloudEvent buildReplyMessage(CloudEvent reqMessage, T replyMessage) {
        CloudEvent cloudEvent = EventMeshCloudEventBuilder.buildEventMeshCloudEvent(replyMessage, this.clientConfig, this.listener.getProtocolType());
        return CloudEvent.newBuilder((CloudEvent)cloudEvent).putAllAttributes(reqMessage.getAttributesMap()).putAllAttributes(cloudEvent.getAttributesMap()).putAttributes("datacontenttype", CloudEvent.CloudEventAttributeValue.newBuilder().setCeString(EventMeshDataContentType.JSON.getCode()).build()).putAttributes("submessagetype", CloudEvent.CloudEventAttributeValue.newBuilder().setCeString("subscription_reply").build()).build();
    }

    @Override
    public void run() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            log.error("SubStreamHandler Thread interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public void close() {
        if (this.sender != null) {
            this.senderOnComplete();
        }
        this.latch.countDown();
        log.info("SubStreamHandler closed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void senderOnNext(CloudEvent subscription) {
        try {
            StreamObserver<CloudEvent> streamObserver = this.sender;
            synchronized (streamObserver) {
                this.sender.onNext((Object)subscription);
            }
        }
        catch (Exception e) {
            log.error("StreamObserver Error onNext", (Throwable)e);
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void senderOnComplete() {
        try {
            StreamObserver<CloudEvent> streamObserver = this.sender;
            synchronized (streamObserver) {
                this.sender.onCompleted();
            }
        }
        catch (Exception e) {
            log.error("StreamObserver Error onComplete", (Throwable)e);
        }
    }
}

