/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.cache;

import com.navercorp.pinpoint.common.annotations.VisibleForTesting;
import com.navercorp.pinpoint.common.profiler.concurrent.ExecutorFactory;
import com.navercorp.pinpoint.common.util.CpuUtils;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public class ExecutorManager {
    private volatile ExecutorService executor;

    @VisibleForTesting
    static ExecutorService cacheExecutor() {
        int nThreads = ExecutorManager.cpuCount(CpuUtils.cpuCount());
        return ExecutorFactory.newFixedThreadPool((int)nThreads, (int)Integer.MAX_VALUE, (String)"Caffeine", (boolean)true);
    }

    @VisibleForTesting
    static int cpuCount(int cpuCount) {
        if (--cpuCount <= 0) {
            return 1;
        }
        return Math.min(cpuCount, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public Executor executor() {
        if (this.executor != null) {
            return this.executor;
        }
        ExecutorManager executorManager = this;
        synchronized (executorManager) {
            if (this.executor != null) {
                return this.executor;
            }
            this.executor = ExecutorManager.cacheExecutor();
            return this.executor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void shutdown() {
        if (this.executor == null) {
            return;
        }
        ExecutorManager executorManager = this;
        synchronized (executorManager) {
            if (this.executor == null) {
                return;
            }
            this.executor.shutdown();
            try {
                this.executor.awaitTermination(3000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.executor = null;
        }
    }
}

