/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument;

import com.navercorp.pinpoint.profiler.instrument.ASMMethodInsnNodeRemapper;
import com.navercorp.pinpoint.profiler.instrument.ASMMethodVariables;
import com.navercorp.pinpoint.profiler.instrument.ASMTryCatch;
import com.navercorp.pinpoint.profiler.instrument.interceptor.InterceptorDefinition;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class ASMMethodNodeAdapter {
    private final String declaringClassInternalName;
    private final MethodNode methodNode;
    private final ASMMethodVariables methodVariables;

    public ASMMethodNodeAdapter(String declaringClassInternalName, MethodNode methodNode) {
        if (declaringClassInternalName == null || methodNode == null) {
            throw new IllegalArgumentException("declaring class internal name and method annotation must not be null. class=" + declaringClassInternalName + ", methodNode=" + methodNode);
        }
        if (methodNode.instructions == null || methodNode.desc == null) {
            throw new IllegalArgumentException("method annotation's instructions or desc must not be null. class=" + declaringClassInternalName + ", method=" + methodNode.name + methodNode.desc);
        }
        this.declaringClassInternalName = declaringClassInternalName;
        this.methodNode = methodNode;
        this.methodVariables = new ASMMethodVariables(declaringClassInternalName, methodNode);
    }

    public MethodNode getMethodNode() {
        return this.methodNode;
    }

    public String getDeclaringClassInternalName() {
        return this.declaringClassInternalName;
    }

    public boolean hasInterceptor() {
        return this.methodVariables.hasInterceptor();
    }

    public String getName() {
        if (this.isConstructor()) {
            int index = this.declaringClassInternalName.lastIndexOf(47);
            if (index < 0) {
                return this.declaringClassInternalName;
            }
            return this.declaringClassInternalName.substring(index + 1);
        }
        return this.methodNode.name;
    }

    public void setName(String name) {
        if (this.isConstructor()) {
            return;
        }
        this.methodNode.name = name;
    }

    public String[] getParameterTypes() {
        return this.methodVariables.getParameterTypes();
    }

    public String[] getParameterNames() {
        return this.methodVariables.getParameterNames();
    }

    public String getReturnType() {
        return this.methodVariables.getReturnType();
    }

    public int getAccess() {
        return this.methodNode.access;
    }

    public void setAccess(int access) {
        this.methodNode.access = access;
    }

    public boolean isConstructor() {
        return this.methodNode.name.equals("<init>");
    }

    public String getDesc() {
        return this.methodNode.desc;
    }

    public int getLineNumber() {
        for (AbstractInsnNode node = this.methodNode.instructions.getFirst(); node != null; node = node.getNext()) {
            if (node.getType() != 15) continue;
            return ((LineNumberNode)node).line;
        }
        return 0;
    }

    public List<String> getExceptions() {
        return this.methodNode.exceptions;
    }

    public String getSignature() {
        return this.methodNode.signature;
    }

    public String getLongName() {
        return this.declaringClassInternalName + "/" + this.getName() + this.getDesc();
    }

    public boolean isStatic() {
        return (this.methodNode.access & 8) != 0;
    }

    public boolean isAbstract() {
        return (this.methodNode.access & 0x400) != 0;
    }

    public boolean isPrivate() {
        return (this.methodNode.access & 2) != 0;
    }

    public boolean isNative() {
        return (this.methodNode.access & 0x100) != 0;
    }

    public boolean hasAnnotation(Class<?> annotationClass) {
        if (annotationClass == null) {
            return false;
        }
        String desc = Type.getDescriptor(annotationClass);
        return this.hasAnnotation(desc, this.methodNode.invisibleAnnotations) || this.hasAnnotation(desc, this.methodNode.visibleAnnotations);
    }

    private boolean hasAnnotation(String annotationClassDesc, List<AnnotationNode> annotationNodes) {
        if (annotationClassDesc == null || annotationNodes == null) {
            return false;
        }
        for (AnnotationNode annotation : annotationNodes) {
            if (annotation.desc == null || !annotation.desc.equals(annotationClassDesc)) continue;
            return true;
        }
        return false;
    }

    public void addDelegator(String superClassInternalName) {
        Objects.requireNonNull(superClassInternalName, "superClassInternalName");
        InsnList instructions = this.methodNode.instructions;
        if (this.isStatic()) {
            this.methodVariables.initLocalVariables(instructions);
            this.methodVariables.loadArgs(instructions);
            instructions.add((AbstractInsnNode)new MethodInsnNode(184, superClassInternalName, this.methodNode.name, this.methodNode.desc, false));
        } else {
            this.methodVariables.initLocalVariables(instructions);
            this.methodVariables.loadVar(instructions, 0);
            this.methodVariables.loadArgs(instructions);
            instructions.add((AbstractInsnNode)new MethodInsnNode(183, superClassInternalName, this.methodNode.name, this.methodNode.desc, false));
        }
        this.methodVariables.returnValue(instructions);
    }

    public void rename(String name) {
        if (name == null) {
            throw new IllegalArgumentException("methodName");
        }
        ASMMethodInsnNodeRemapper.Builder remapBuilder = new ASMMethodInsnNodeRemapper.Builder();
        remapBuilder.addFilter(this.declaringClassInternalName, this.methodNode.name, this.methodNode.desc);
        remapBuilder.setName(name);
        ASMMethodInsnNodeRemapper remapper = remapBuilder.build();
        this.remapMethodInsnNode(remapper);
        this.methodNode.name = name;
    }

    public void remapMethodInsnNode(ASMMethodInsnNodeRemapper remapper) {
        for (AbstractInsnNode insnNode = this.methodNode.instructions.getFirst(); insnNode != null; insnNode = insnNode.getNext()) {
            if (!(insnNode instanceof MethodInsnNode)) continue;
            MethodInsnNode methodInsnNode = (MethodInsnNode)insnNode;
            remapper.mapping(methodInsnNode);
        }
    }

    public void remapLocalVariables(String name, String desc) {
        if (this.methodNode.localVariables == null) {
            return;
        }
        List localVariableNodes = this.methodNode.localVariables;
        for (LocalVariableNode node : localVariableNodes) {
            if (!node.name.equals(name)) continue;
            node.desc = desc;
        }
    }

    private void initInterceptorLocalVariables(int interceptorId, InterceptorDefinition interceptorDefinition, int apiId) {
        InsnList instructions = new InsnList();
        if (this.methodVariables.initInterceptorLocalVariables(instructions, interceptorId, interceptorDefinition, apiId)) {
            this.methodNode.instructions.insertBefore(this.methodVariables.getEnterInsnNode(), instructions);
        }
    }

    public void addBeforeInterceptor(int interceptorId, InterceptorDefinition interceptorDefinition, int apiId) {
        this.initInterceptorLocalVariables(interceptorId, interceptorDefinition, apiId);
        InsnList instructions = new InsnList();
        this.methodVariables.loadInterceptorLocalVariables(instructions, interceptorDefinition, false);
        String description = Type.getMethodDescriptor((Method)interceptorDefinition.getBeforeMethod());
        instructions.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(interceptorDefinition.getInterceptorBaseClass()), "before", description, true));
        this.methodNode.instructions.insertBefore(this.methodVariables.getEnterInsnNode(), instructions);
    }

    public void addAfterInterceptor(int interceptorId, InterceptorDefinition interceptorDefinition, int apiId) {
        this.initInterceptorLocalVariables(interceptorId, interceptorDefinition, apiId);
        ASMTryCatch tryCatch = new ASMTryCatch(this.methodNode);
        this.methodNode.instructions.insertBefore(this.methodVariables.getEnterInsnNode(), (AbstractInsnNode)tryCatch.getStartLabelNode());
        this.methodNode.instructions.insert(this.methodVariables.getExitInsnNode(), (AbstractInsnNode)tryCatch.getEndLabelNode());
        for (AbstractInsnNode insnNode = this.methodNode.instructions.getFirst(); insnNode != null; insnNode = insnNode.getNext()) {
            int opcode = insnNode.getOpcode();
            if (!this.methodVariables.isReturnCode(opcode)) continue;
            InsnList instructions = new InsnList();
            this.methodVariables.storeResultVar(instructions, opcode);
            this.invokeAfterInterceptor(instructions, interceptorDefinition, false);
            this.methodNode.instructions.insertBefore(insnNode, instructions);
        }
        InsnList instructions = new InsnList();
        this.methodVariables.storeThrowableVar(instructions);
        this.invokeAfterInterceptor(instructions, interceptorDefinition, true);
        this.methodVariables.loadInterceptorThrowVar(instructions);
        this.methodNode.instructions.insert((AbstractInsnNode)tryCatch.getEndLabelNode(), instructions);
        tryCatch.sort();
    }

    private void invokeAfterInterceptor(InsnList instructions, InterceptorDefinition interceptorDefinition, boolean throwable) {
        this.methodVariables.loadInterceptorLocalVariables(instructions, interceptorDefinition, true);
        String description = Type.getMethodDescriptor((Method)interceptorDefinition.getAfterMethod());
        instructions.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(interceptorDefinition.getInterceptorBaseClass()), "after", description, true));
    }
}

