/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument.scanner;

import com.navercorp.pinpoint.profiler.instrument.scanner.Scanner;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Objects;

public class DirectoryScanner
implements Scanner {
    private final File directory;

    public DirectoryScanner(String directory) {
        Objects.requireNonNull(directory, "directory");
        this.directory = new File(directory);
    }

    @Override
    public boolean exist(String fileName) {
        Objects.requireNonNull(fileName, "fileName");
        File file = new File(this.directory, fileName);
        return file.isFile();
    }

    @Override
    public InputStream openStream(String fileName) {
        Objects.requireNonNull(fileName, "fileName");
        File fullPath = new File(this.directory, fileName);
        try {
            return new FileInputStream(fullPath);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    @Override
    public void close() {
    }

    public String toString() {
        return "DirectoryScanner{directory='" + this.directory + '\'' + '}';
    }
}

