/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.plugin.filter;

import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.profiler.plugin.config.PluginLoadingConfig;
import com.navercorp.pinpoint.profiler.plugin.filter.DisabledPluginFilter;
import com.navercorp.pinpoint.profiler.plugin.filter.JavaVersionFilter;
import com.navercorp.pinpoint.profiler.plugin.filter.PluginFilter;
import com.navercorp.pinpoint.profiler.plugin.filter.PluginFilterFactory;
import com.navercorp.pinpoint.profiler.plugin.filter.PluginFilters;
import java.util.List;
import java.util.Objects;

public class DefaultPluginFilterFactory
implements PluginFilterFactory {
    private final List<String> disabledPlugins;

    public DefaultPluginFilterFactory(PluginLoadingConfig pluginLoadingConfig) {
        Objects.requireNonNull(pluginLoadingConfig, "pluginLoadingConfig");
        this.disabledPlugins = pluginLoadingConfig.getDisabledPlugins();
    }

    @Override
    public PluginFilter newPluginFilter() {
        if (CollectionUtils.isEmpty(this.disabledPlugins)) {
            return new JavaVersionFilter();
        }
        JavaVersionFilter javaVersionFilter = new JavaVersionFilter();
        DisabledPluginFilter disabledPluginFilter = new DisabledPluginFilter(this.disabledPlugins);
        return new PluginFilters(disabledPluginFilter, javaVersionFilter);
    }
}

