/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.util;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class RuntimeMXBeanUtils {
    private static final RuntimeMXBean RUNTIME_MBEAN = ManagementFactory.getRuntimeMXBean();
    private static long START_TIME = 0L;
    private static int PID = 0;
    private static final Random RANDOM = new Random();

    private RuntimeMXBeanUtils() {
    }

    public static int getPid() {
        if (PID == 0) {
            PID = RuntimeMXBeanUtils.getPid0();
        }
        return PID;
    }

    public static List<String> getVmArgs() {
        List<String> vmArgs = RUNTIME_MBEAN.getInputArguments();
        if (vmArgs == null) {
            return Collections.emptyList();
        }
        return vmArgs;
    }

    private static int getPid0() {
        String name = RUNTIME_MBEAN.getName();
        int pidIndex = name.indexOf(64);
        if (pidIndex == -1) {
            RuntimeMXBeanUtils.getLogger().warn("invalid pid name:" + name);
            return RuntimeMXBeanUtils.getNegativeRandomValue();
        }
        String strPid = name.substring(0, pidIndex);
        try {
            return Integer.parseInt(strPid);
        }
        catch (NumberFormatException e) {
            return RuntimeMXBeanUtils.getNegativeRandomValue();
        }
    }

    private static int getNegativeRandomValue() {
        int abs = Math.abs(RANDOM.nextInt());
        if (abs == Integer.MIN_VALUE) {
            return -1;
        }
        return abs;
    }

    public static long getVmStartTime() {
        if (START_TIME == 0L) {
            START_TIME = RuntimeMXBeanUtils.getVmStartTime0();
        }
        return START_TIME;
    }

    private static long getVmStartTime0() {
        try {
            return RUNTIME_MBEAN.getStartTime();
        }
        catch (UnsupportedOperationException e) {
            Logger logger = RuntimeMXBeanUtils.getLogger();
            logger.warn("RuntimeMXBean.getStartTime() unsupported. Caused:" + e.getMessage(), (Throwable)e);
            return System.currentTimeMillis();
        }
    }

    public static String getName() {
        return RUNTIME_MBEAN.getName();
    }

    private static Logger getLogger() {
        return LogManager.getLogger(RuntimeMXBeanUtils.class);
    }
}

