/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.profiler.clock;

import com.navercorp.pinpoint.common.profiler.clock.Clock;
import java.util.Objects;

public class TickClock
implements Clock {
    private final Clock baseClock;
    private final long tick;

    public TickClock(Clock baseClock, long tick) {
        this.baseClock = Objects.requireNonNull(baseClock, "baseClock");
        if (tick < 0L) {
            throw new IllegalArgumentException("negative tick");
        }
        this.tick = tick;
    }

    @Override
    public long millis() {
        long millis = this.baseClock.millis();
        return this.tick(millis);
    }

    public long tick(long millis) {
        return millis - millis % this.tick;
    }
}

