/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.recommend;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.meta.dto.EventMeshDataInfo;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.recommend.EventMeshRecommendStrategy;
import org.apache.eventmesh.runtime.util.ValueComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshRecommendImpl
implements EventMeshRecommendStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventMeshRecommendImpl.class);
    private static final int DEFAULT_PROXY_NUM = 1;
    private final transient EventMeshTCPServer eventMeshTCPServer;

    public EventMeshRecommendImpl(EventMeshTCPServer eventMeshTCPServer) {
        this.eventMeshTCPServer = eventMeshTCPServer;
    }

    @Override
    public String calculateRecommendEventMesh(String group, String purpose) throws Exception {
        List<EventMeshDataInfo> eventMeshDataInfoList;
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{group, purpose})) {
            log.warn("EventMeshRecommend failed,params illegal,group:{},purpose:{}", (Object)group, (Object)purpose);
            return null;
        }
        String cluster = this.eventMeshTCPServer.getEventMeshTCPConfiguration().getEventMeshCluster();
        try {
            eventMeshDataInfoList = this.eventMeshTCPServer.getMetaStorage().findEventMeshInfoByCluster(cluster);
        }
        catch (Exception e) {
            log.warn("EventMeshRecommend failed, findEventMeshInfoByCluster failed, cluster:{}, group:{}, purpose:{}, errMsg:{}", new Object[]{cluster, group, purpose, e});
            return null;
        }
        if (CollectionUtils.isEmpty(eventMeshDataInfoList)) {
            log.warn("EventMeshRecommend failed, not find eventMesh instances from registry, cluster:{},group:{},purpose:{}", new Object[]{cluster, group, purpose});
            return null;
        }
        HashMap<String, String> localEventMeshMap = new HashMap<String, String>();
        HashMap<String, String> remoteEventMeshMap = new HashMap<String, String>();
        String localIdc = this.eventMeshTCPServer.getEventMeshTCPConfiguration().getEventMeshIDC();
        for (EventMeshDataInfo eventMeshDataInfo : eventMeshDataInfoList) {
            String idc = eventMeshDataInfo.getEventMeshName().split("-")[0];
            if (StringUtils.isNotBlank((CharSequence)idc)) {
                String string = StringUtils.equals((CharSequence)idc, (CharSequence)localIdc) ? localEventMeshMap.put(eventMeshDataInfo.getEventMeshName(), eventMeshDataInfo.getEndpoint()) : remoteEventMeshMap.put(eventMeshDataInfo.getEventMeshName(), eventMeshDataInfo.getEndpoint());
                continue;
            }
            log.error("EventMeshName may be illegal,idc is null,eventMeshName:{}", (Object)eventMeshDataInfo.getEventMeshName());
        }
        if (MapUtils.isNotEmpty(localEventMeshMap)) {
            return this.recommendProxyByDistributeData(cluster, group, purpose, localEventMeshMap, true);
        }
        if (MapUtils.isNotEmpty(remoteEventMeshMap)) {
            return this.recommendProxyByDistributeData(cluster, group, purpose, remoteEventMeshMap, false);
        }
        log.error("localEventMeshMap or remoteEventMeshMap size error");
        return null;
    }

    @Override
    public List<String> calculateRedirectRecommendEventMesh(Map<String, String> eventMeshMap, Map<String, Integer> clientDistributedMap, String group, int recommendProxyNum, String eventMeshName) throws Exception {
        Objects.requireNonNull(eventMeshMap, "eventMeshMap can not be null");
        Objects.requireNonNull(clientDistributedMap, "clientDistributedMap can not be null");
        if (recommendProxyNum < 1 || MapUtils.isEmpty(clientDistributedMap)) {
            return new ArrayList<String>();
        }
        log.info("eventMeshMap:{},clientDistributionMap:{},group:{},recommendNum:{},currEventMeshName:{}", new Object[]{eventMeshMap, clientDistributedMap, group, recommendProxyNum, eventMeshName});
        ArrayList clientDistributedList = new ArrayList();
        ValueComparator vc = new ValueComparator();
        clientDistributedMap.entrySet().forEach(clientDistributedList::add);
        Collections.sort(clientDistributedList, vc);
        log.info("clientDistributedLists after sort:{}", clientDistributedList);
        ArrayList<String> recommendProxyList = new ArrayList<String>(recommendProxyNum);
        while (recommendProxyList.size() < recommendProxyNum) {
            Map.Entry minProxyItem = (Map.Entry)clientDistributedList.get(0);
            int currProxyNum = clientDistributedMap.get(eventMeshName);
            recommendProxyList.add(eventMeshMap.get(minProxyItem.getKey()));
            clientDistributedMap.put((String)minProxyItem.getKey(), (Integer)minProxyItem.getValue() + 1);
            clientDistributedMap.put(eventMeshName, currProxyNum - 1);
            Collections.sort(clientDistributedList, vc);
            log.info("clientDistributedList after sort:{}", clientDistributedList);
        }
        log.info("choose proxys with min instance num, group:{}, recommendProxyNum:{}, recommendProxyList:{}", new Object[]{group, recommendProxyNum, recommendProxyList});
        return recommendProxyList;
    }

    private String recommendProxyByDistributeData(String cluster, String group, String purpose, Map<String, String> eventMeshMap, boolean caculateLocal) {
        Objects.requireNonNull(eventMeshMap, "eventMeshMap can not be null");
        log.info("eventMeshMap:{},cluster:{},group:{},purpose:{},caculateLocal:{}", new Object[]{eventMeshMap, cluster, group, purpose, caculateLocal});
        Map<String, Map<String, Integer>> eventMeshClientDistributionDataMap = null;
        try {
            eventMeshClientDistributionDataMap = this.eventMeshTCPServer.getMetaStorage().findEventMeshClientDistributionData(cluster, group, purpose);
        }
        catch (Exception e) {
            log.warn("EventMeshRecommend failed,findEventMeshClientDistributionData failed,cluster:{},group:{},purpose:{}, errMsg:{}", new Object[]{cluster, group, purpose, e});
        }
        if (MapUtils.isEmpty(eventMeshClientDistributionDataMap)) {
            ArrayList<String> tmpProxyAddrList = new ArrayList<String>(eventMeshMap.values());
            if (CollectionUtils.isEmpty(tmpProxyAddrList)) {
                return null;
            }
            Collections.shuffle(tmpProxyAddrList);
            String recommendProxyAddr = (String)tmpProxyAddrList.get(0);
            log.info("No distribute data in registry,cluster:{}, group:{},purpose:{}, recommendProxyAddr:{}", new Object[]{cluster, group, purpose, recommendProxyAddr});
            return recommendProxyAddr;
        }
        HashMap<String, Integer> localClientDistributionMap = new HashMap<String, Integer>();
        HashMap remoteClientDistributionMap = new HashMap();
        eventMeshClientDistributionDataMap.entrySet().forEach(entry -> {
            String idc = ((String)entry.getKey()).split("-")[0];
            if (StringUtils.isNotBlank((CharSequence)idc)) {
                if (StringUtils.equals((CharSequence)idc, (CharSequence)this.eventMeshTCPServer.getEventMeshTCPConfiguration().getEventMeshIDC())) {
                    localClientDistributionMap.put((String)entry.getKey(), (Integer)((Map)entry.getValue()).get(purpose));
                } else {
                    remoteClientDistributionMap.put((String)entry.getKey(), (Integer)((Map)entry.getValue()).get(purpose));
                }
            } else {
                log.error("eventMeshName may be illegal,idc is null,eventMeshName:{}", entry.getKey());
            }
        });
        String recommendProxyAddr = this.recommendProxy(eventMeshMap, caculateLocal ? localClientDistributionMap : remoteClientDistributionMap, group);
        log.info("eventMeshMap:{},group:{},purpose:{},caculateLocal:{},recommendProxyAddr:{}", new Object[]{eventMeshMap, group, purpose, caculateLocal, recommendProxyAddr});
        return recommendProxyAddr;
    }

    private String recommendProxy(Map<String, String> eventMeshMap, Map<String, Integer> clientDistributionMap, String group) {
        Objects.requireNonNull(eventMeshMap, "eventMeshMap can not be null");
        Objects.requireNonNull(clientDistributionMap, "clientDistributionMap can not be null");
        log.info("eventMeshMap:{},clientDistributionMap:{},group:{}", new Object[]{eventMeshMap, clientDistributionMap, group});
        if (!eventMeshMap.keySet().containsAll(clientDistributionMap.keySet())) {
            log.warn("exist proxy not register but exist in distributionMap");
            return null;
        }
        eventMeshMap.keySet().forEach(proxy -> clientDistributionMap.putIfAbsent((String)proxy, 0));
        if (MapUtils.isEmpty(clientDistributionMap)) {
            log.error("no legal distribute data,check eventMeshMap and distributeData, group:{}", (Object)group);
            return null;
        }
        ArrayList list = new ArrayList();
        clientDistributionMap.entrySet().forEach(list::add);
        Collections.sort(list, new ValueComparator());
        log.info("clientDistributionMap after sort:{}", list);
        return eventMeshMap.get(((Map.Entry)list.get(0)).getKey());
    }
}

