/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.storage.standalone.broker.task;

import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.eventmesh.storage.standalone.broker.MessageQueue;
import org.apache.eventmesh.storage.standalone.broker.model.MessageEntity;
import org.apache.eventmesh.storage.standalone.broker.model.TopicMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistoryMessageClear {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HistoryMessageClear.class);
    private final ConcurrentHashMap<TopicMetadata, MessageQueue> messageContainer;
    private static final long MESSAGE_STORE_WINDOW = 3600000L;

    public HistoryMessageClear(ConcurrentHashMap<TopicMetadata, MessageQueue> messageContainer) {
        this.messageContainer = messageContainer;
    }

    public void clearMessages() {
        this.messageContainer.forEach((topicMetadata, messageQueue) -> {
            long currentTimeMillis = System.currentTimeMillis();
            MessageEntity oldestMessage = messageQueue.getHead();
            if (oldestMessage == null) {
                return;
            }
            if (currentTimeMillis - oldestMessage.getCreateTimeMills() >= 3600000L) {
                messageQueue.removeHead();
            }
        });
    }
}

