/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.loan;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.cob.loan.LoanCOBBusinessStep;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.repayment.LoanRepaymentDueBusinessEvent;
import org.apache.fineract.infrastructure.event.business.service.BusinessEventNotifierService;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleInstallment;
import org.apache.fineract.portfolio.loanaccount.domain.LoanStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class CheckLoanRepaymentDueBusinessStep
implements LoanCOBBusinessStep {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CheckLoanRepaymentDueBusinessStep.class);
    private final ConfigurationDomainService configurationDomainService;
    private final BusinessEventNotifierService businessEventNotifierService;

    public Loan execute(Loan loan) {
        log.debug("start processing loan repayment due business step loan for loan with id [{}]", (Object)loan.getId());
        Long numberOfDaysBeforeDueDateToRaiseEvent = this.configurationDomainService.retrieveRepaymentDueDays();
        if (loan.getLoanProduct().getDueDaysForRepaymentEvent() != null && loan.getLoanProduct().getDueDaysForRepaymentEvent() > 0) {
            numberOfDaysBeforeDueDateToRaiseEvent = loan.getLoanProduct().getDueDaysForRepaymentEvent().longValue();
        }
        LocalDate currentDate = DateUtils.getBusinessLocalDate();
        List loanRepaymentScheduleInstallments = loan.getRepaymentScheduleInstallments();
        for (LoanRepaymentScheduleInstallment repaymentSchedule : loanRepaymentScheduleInstallments) {
            List<LoanStatus> nonDisbursedStatuses;
            LocalDate repaymentDate;
            if (!CheckLoanRepaymentDueBusinessStep.isDueEventNeededToBeSent((Loan)loan, (Long)numberOfDaysBeforeDueDateToRaiseEvent, (LocalDate)currentDate, (LoanRepaymentScheduleInstallment)repaymentSchedule, (LocalDate)(repaymentDate = repaymentSchedule.getDueDate()), nonDisbursedStatuses = Arrays.asList(LoanStatus.INVALID, LoanStatus.SUBMITTED_AND_PENDING_APPROVAL, LoanStatus.APPROVED))) continue;
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanRepaymentDueBusinessEvent(repaymentSchedule));
            break;
        }
        log.debug("end processing loan repayment due business step loan for loan with id [{}]", (Object)loan.getId());
        return loan;
    }

    public String getEnumStyledName() {
        return "CHECK_LOAN_REPAYMENT_DUE";
    }

    public String getHumanReadableName() {
        return "Check loan repayment due";
    }

    private static boolean isDueEventNeededToBeSent(Loan loan, Long numberOfDaysBeforeDueDateToRaiseEvent, LocalDate currentDate, LoanRepaymentScheduleInstallment repaymentScheduleInstallment, LocalDate repaymentDate, List<LoanStatus> nonDisbursedStatuses) {
        return repaymentDate.minusDays(numberOfDaysBeforeDueDateToRaiseEvent).equals(currentDate) && !nonDisbursedStatuses.contains(loan.getStatus()) && loan.getSummary().getTotalOutstanding().compareTo(BigDecimal.ZERO) > 0 && repaymentScheduleInstallment.getTotalOutstanding(loan.getCurrency()).isGreaterThanZero();
    }

    @Generated
    public CheckLoanRepaymentDueBusinessStep(ConfigurationDomainService configurationDomainService, BusinessEventNotifierService businessEventNotifierService) {
        this.configurationDomainService = configurationDomainService;
        this.businessEventNotifierService = businessEventNotifierService;
    }
}

