/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.configuration.service;

import lombok.Generated;
import org.apache.fineract.infrastructure.configuration.domain.GlobalConfigurationProperty;
import org.apache.fineract.infrastructure.configuration.domain.GlobalConfigurationRepositoryWrapper;
import org.apache.fineract.infrastructure.core.domain.FineractPlatformTenant;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.organisation.monetary.domain.MoneyHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MoneyHelperInitializationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MoneyHelperInitializationService.class);
    private final GlobalConfigurationRepositoryWrapper globalConfigurationRepository;

    public void initializeTenantRoundingMode(FineractPlatformTenant tenant) {
        if (tenant == null) {
            throw new IllegalArgumentException("Tenant cannot be null");
        }
        String tenantIdentifier = tenant.getTenantIdentifier();
        try {
            ThreadLocalContextUtil.setTenant((FineractPlatformTenant)tenant);
            int roundingModeValue = this.getRoundingModeFromConfiguration();
            MoneyHelper.initializeTenantRoundingMode((String)tenantIdentifier, (int)roundingModeValue);
        }
        catch (Exception e) {
            log.error("Failed to initialize MoneyHelper for tenant '{}'", (Object)tenantIdentifier, (Object)e);
            throw new RuntimeException("Failed to initialize MoneyHelper for tenant: " + tenantIdentifier, e);
        }
        finally {
            ThreadLocalContextUtil.clearTenant();
        }
    }

    public boolean isTenantInitialized(String tenantIdentifier) {
        return MoneyHelper.isTenantInitialized((String)tenantIdentifier);
    }

    private int getRoundingModeFromConfiguration() {
        GlobalConfigurationProperty roundingModeProperty = this.globalConfigurationRepository.findOneByNameWithNotFoundDetection("rounding-mode");
        return roundingModeProperty.getValue().intValue();
    }

    @Generated
    public MoneyHelperInitializationService(GlobalConfigurationRepositoryWrapper globalConfigurationRepository) {
        this.globalConfigurationRepository = globalConfigurationRepository;
    }
}

