package org.apache.fineract.client.services;

import org.apache.fineract.client.CollectionFormats.*;

    import retrofit2.Call;
import retrofit2.http.*;

import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.MultipartBody;

import org.apache.fineract.client.models.DeleteClientsClientIdResponse;
import java.io.File;
import org.apache.fineract.client.models.GetClientObligeeDetailsResponse;
import org.apache.fineract.client.models.GetClientTransferProposalDateResponse;
import org.apache.fineract.client.models.GetClientsClientIdAccountsResponse;
import org.apache.fineract.client.models.GetClientsClientIdResponse;
import org.apache.fineract.client.models.GetClientsResponse;
import org.apache.fineract.client.models.GetClientsTemplateResponse;
import org.apache.fineract.client.models.PostClientsClientIdRequest;
import org.apache.fineract.client.models.PostClientsClientIdResponse;
import org.apache.fineract.client.models.PostClientsRequest;
import org.apache.fineract.client.models.PostClientsResponse;
import org.apache.fineract.client.models.PutClientsClientIdRequest;
import org.apache.fineract.client.models.PutClientsClientIdResponse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface ClientApi {
    /**
    * Activate a Client | Close a Client | Reject a Client | Withdraw a Client | Reactivate a Client | UndoReject a Client | UndoWithdraw a Client | Assign a Staff | Unassign a Staff | Update Default Savings Account | Propose a Client Transfer | Withdraw a Client Transfer | Reject a Client Transfer | Accept a Client Transfer | Propose and Accept a Client Transfer
    * Activate a Client:  Clients can be created in a Pending state. This API exists to enable client activation (for when a client becomes an approved member of the financial Institution).  If the client happens to be already active this API will result in an error.  Close a Client:  Clients can be closed if they do not have any non-closed loans/savingsAccount. This API exists to close a client .  If the client have any active loans/savingsAccount this API will result in an error.  Reject a Client:  Clients can be rejected when client is in pending for activation status.  If the client is any other status, this API throws an error.  Mandatory Fields: rejectionDate, rejectionReasonId  Withdraw a Client:  Client applications can be withdrawn when client is in a pending for activation status.  If the client is any other status, this API throws an error.  Mandatory Fields: withdrawalDate, withdrawalReasonId  Reactivate a Client: Clients can be reactivated after they have been closed.  Trying to reactivate a client in any other state throws an error.  Mandatory Fields: reactivationDate  UndoReject a Client:  Clients can be reactivated after they have been rejected.  Trying to reactivate a client in any other state throws an error.  Mandatory Fields: reopenedDateUndoWithdraw a Client:  Clients can be reactivated after they have been withdrawn.  Trying to reactivate a client in any other state throws an error.  Mandatory Fields: reopenedDate  Assign a Staff:  Allows you to assign a Staff for existed Client.  The selected Staff should belong to the same office (or an officer higher up in the hierarchy) as the Client he manages.  Unassign a Staff:  Allows you to unassign the Staff assigned to a Client.  Update Default Savings Account:  Allows you to modify or assign a default savings account for an existing Client.  The selected savings account should be one among the existing savings account for a particular customer.  Propose a Client Transfer:  Allows you to propose the transfer of a Client to a different Office.  Withdraw a Client Transfer:  Allows you to withdraw the proposed transfer of a Client to a different Office.  Withdrawal can happen only if the destination Branch (to which the transfer was proposed) has not already accepted the transfer proposal  Reject a Client Transfer:  Allows the Destination Branch to reject the proposed Client Transfer.  Accept a Client Transfer:  Allows the Destination Branch to accept the proposed Client Transfer.  The destination branch may also choose to link this client to a group (in which case, any existing active JLG loan of the client is rescheduled to match the meeting frequency of the group) and loan Officer at the time of accepting the transfer  Propose and Accept a Client Transfer:  Abstraction over the Propose and Accept Client Transfer API&#39;s which enable a user with Data Scope over both the Target and Destination Branches to directly transfer a Client to the destination Office.  Showing request/response for &#39;Reject a Client Transfer&#39;
        * @param clientId clientId (required)
        * @param postClientsClientIdRequest  (required)
        * @param command command (optional)
    * @return Call&lt;PostClientsClientIdResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/clients/{clientId}")
    Call<PostClientsClientIdResponse> activate1(@retrofit2.http.Path("clientId") Long clientId, @retrofit2.http.Body PostClientsClientIdRequest postClientsClientIdRequest, @retrofit2.http.Query("command") String command);

    /**
    * Activate a Client | Close a Client | Reject a Client | Withdraw a Client | Reactivate a Client | UndoReject a Client | UndoWithdraw a Client | Assign a Staff | Unassign a Staff | Update Default Savings Account | Propose a Client Transfer | Withdraw a Client Transfer | Reject a Client Transfer | Accept a Client Transfer | Propose and Accept a Client Transfer
    * Activate a Client:  Clients can be created in a Pending state. This API exists to enable client activation (for when a client becomes an approved member of the financial Institution).  If the client happens to be already active this API will result in an error.  Close a Client:  Clients can be closed if they do not have any non-closed loans/savingsAccount. This API exists to close a client .  If the client have any active loans/savingsAccount this API will result in an error.  Reject a Client:  Clients can be rejected when client is in pending for activation status.  If the client is any other status, this API throws an error.  Mandatory Fields: rejectionDate, rejectionReasonId  Withdraw a Client:  Client applications can be withdrawn when client is in a pending for activation status.  If the client is any other status, this API throws an error.  Mandatory Fields: withdrawalDate, withdrawalReasonId  Reactivate a Client: Clients can be reactivated after they have been closed.  Trying to reactivate a client in any other state throws an error.  Mandatory Fields: reactivationDate  UndoReject a Client:  Clients can be reactivated after they have been rejected.  Trying to reactivate a client in any other state throws an error.  Mandatory Fields: reopenedDateUndoWithdraw a Client:  Clients can be reactivated after they have been withdrawn.  Trying to reactivate a client in any other state throws an error.  Mandatory Fields: reopenedDate  Assign a Staff:  Allows you to assign a Staff for existed Client.  The selected Staff should belong to the same office (or an officer higher up in the hierarchy) as the Client he manages.  Unassign a Staff:  Allows you to unassign the Staff assigned to a Client.  Update Default Savings Account:  Allows you to modify or assign a default savings account for an existing Client.  The selected savings account should be one among the existing savings account for a particular customer.  Propose a Client Transfer:  Allows you to propose the transfer of a Client to a different Office.  Withdraw a Client Transfer:  Allows you to withdraw the proposed transfer of a Client to a different Office.  Withdrawal can happen only if the destination Branch (to which the transfer was proposed) has not already accepted the transfer proposal  Reject a Client Transfer:  Allows the Destination Branch to reject the proposed Client Transfer.  Accept a Client Transfer:  Allows the Destination Branch to accept the proposed Client Transfer.  The destination branch may also choose to link this client to a group (in which case, any existing active JLG loan of the client is rescheduled to match the meeting frequency of the group) and loan Officer at the time of accepting the transfer  Propose and Accept a Client Transfer:  Abstraction over the Propose and Accept Client Transfer API&#39;s which enable a user with Data Scope over both the Target and Destination Branches to directly transfer a Client to the destination Office.  Showing request/response for &#39;Reject a Client Transfer&#39;
        * @param externalId externalId (required)
        * @param postClientsClientIdRequest  (required)
        * @param command command (optional)
    * @return Call&lt;PostClientsClientIdResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/clients/external-id/{externalId}")
    Call<PostClientsClientIdResponse> applyCommand(@retrofit2.http.Path("externalId") String externalId, @retrofit2.http.Body PostClientsClientIdRequest postClientsClientIdRequest, @retrofit2.http.Query("command") String command);

    /**
    * Create a Client
    * Note:  1. You can enter either:firstname/middlename/lastname - for a person (middlename is optional) OR fullname - for a business or organisation (or person known by one name).  2.If address is enable(enable-address&#x3D;true), then additional field called address has to be passed.  Mandatory Fields: firstname and lastname OR fullname, officeId, active&#x3D;true and activationDate OR active&#x3D;false, if(address enabled) address  Optional Fields: groupId, externalId, accountNo, staffId, mobileNo, savingsProductId, genderId, clientTypeId, clientClassificationId
        * @param postClientsRequest  (required)
    * @return Call&lt;PostClientsResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/clients")
    Call<PostClientsResponse> create6(@retrofit2.http.Body PostClientsRequest postClientsRequest);

    /**
    * Delete a Client
    * If a client is in Pending state, you are allowed to Delete it. The delete is a &#39;hard delete&#39; and cannot be recovered from. Once clients become active or have loans or savings associated with them, you cannot delete the client but you may Close the client if they have left the program.
        * @param clientId clientId (required)
    * @return Call&lt;DeleteClientsClientIdResponse&gt;
    */
    @DELETE("v1/clients/{clientId}")
    Call<DeleteClientsClientIdResponse> delete8(@retrofit2.http.Path("clientId") Long clientId);

    /**
    * Delete a Client
    * If a client is in Pending state, you are allowed to Delete it. The delete is a &#39;hard delete&#39; and cannot be recovered from. Once clients become active or have loans or savings associated with them, you cannot delete the client but you may Close the client if they have left the program.
        * @param externalId externalId (required)
    * @return Call&lt;DeleteClientsClientIdResponse&gt;
    */
    @DELETE("v1/clients/external-id/{externalId}")
    Call<DeleteClientsClientIdResponse> delete9(@retrofit2.http.Path("externalId") String externalId);

    /**
    * 
    * 
        * @param legalFormType  (optional)
        * @param officeId  (optional)
        * @param staffId  (optional)
        * @param dateFormat  (optional)
    * @return Call&lt;Void&gt;
    */
    @GET("v1/clients/downloadtemplate")
    Call<Void> getClientTemplate(@retrofit2.http.Query("legalFormType") String legalFormType, @retrofit2.http.Query("officeId") Long officeId, @retrofit2.http.Query("staffId") Long staffId, @retrofit2.http.Query("dateFormat") String dateFormat);

    /**
    * 
    * 
        * @param legalFormType  (optional)
        * @param dateFormat  (optional)
        * @param locale  (optional)
        * @param uploadedInputStream  (optional)
    * @return Call&lt;String&gt;
    */
            @retrofit2.http.Multipart
    @POST("v1/clients/uploadtemplate")
    Call<String> postClientTemplate(@retrofit2.http.Query("legalFormType") String legalFormType, @retrofit2.http.Part("dateFormat") String dateFormat, @retrofit2.http.Part("locale") String locale, @retrofit2.http.Part MultipartBody.Part uploadedInputStream);

    /**
    * List Clients
    * The list capability of clients can support pagination and sorting.  Example Requests:  clients  clients?fields&#x3D;displayName,officeName,timeline  clients?offset&#x3D;10&amp;limit&#x3D;50  clients?orderBy&#x3D;displayName&amp;sortOrder&#x3D;DESC
        * @param officeId officeId (optional)
        * @param externalId externalId (optional)
        * @param displayName displayName (optional)
        * @param firstName firstName (optional)
        * @param lastName lastName (optional)
        * @param status status (optional)
        * @param underHierarchy underHierarchy (optional)
        * @param offset offset (optional)
        * @param limit limit (optional)
        * @param orderBy orderBy (optional)
        * @param sortOrder sortOrder (optional)
        * @param orphansOnly orphansOnly (optional)
        * @param legalForm  (optional)
    * @return Call&lt;GetClientsResponse&gt;
    */
    @GET("v1/clients")
    Call<GetClientsResponse> retrieveAll21(@retrofit2.http.Query("officeId") Long officeId, @retrofit2.http.Query("externalId") String externalId, @retrofit2.http.Query("displayName") String displayName, @retrofit2.http.Query("firstName") String firstName, @retrofit2.http.Query("lastName") String lastName, @retrofit2.http.Query("status") String status, @retrofit2.http.Query("underHierarchy") String underHierarchy, @retrofit2.http.Query("offset") Integer offset, @retrofit2.http.Query("limit") Integer limit, @retrofit2.http.Query("orderBy") String orderBy, @retrofit2.http.Query("sortOrder") String sortOrder, @retrofit2.http.Query("orphansOnly") Boolean orphansOnly, @retrofit2.http.Query("legalForm") Integer legalForm);

    /**
    * Retrieve client accounts overview
    * An example of how a loan portfolio summary can be provided. This is requested in a specific use case of the community application. It is quite reasonable to add resources like this to simplify User Interface development.  Example Requests:   clients/1/accounts  clients/1/accounts?fields&#x3D;loanAccounts,savingsAccounts
        * @param clientId clientId (required)
    * @return Call&lt;GetClientsClientIdAccountsResponse&gt;
    */
    @GET("v1/clients/{clientId}/accounts")
    Call<GetClientsClientIdAccountsResponse> retrieveAssociatedAccounts(@retrofit2.http.Path("clientId") Long clientId);

    /**
    * Retrieve client accounts overview
    * An example of how a loan portfolio summary can be provided. This is requested in a specific use case of the community application. It is quite reasonable to add resources like this to simplify User Interface development.  Example Requests:   clients/123-456/accounts  clients/123-456/accounts?fields&#x3D;loanAccounts,savingsAccounts
        * @param externalId externalId (required)
    * @return Call&lt;GetClientsClientIdAccountsResponse&gt;
    */
    @GET("v1/clients/external-id/{externalId}/accounts")
    Call<GetClientsClientIdAccountsResponse> retrieveAssociatedAccounts1(@retrofit2.http.Path("externalId") String externalId);

    /**
    * Retrieve client obligee details
    * Retrieve client obligee details
        * @param clientId  (required)
    * @return Call&lt;GetClientObligeeDetailsResponse&gt;
    */
    @GET("v1/clients/{clientId}/obligeedetails")
    Call<GetClientObligeeDetailsResponse> retrieveObligeeDetails(@retrofit2.http.Path("clientId") Long clientId);

    /**
    * Retrieve client obligee details
    * Retrieve client obligee details using the client external Id
        * @param externalId  (required)
    * @return Call&lt;GetClientObligeeDetailsResponse&gt;
    */
    @GET("v1/clients/external-id/{externalId}/obligeedetails")
    Call<GetClientObligeeDetailsResponse> retrieveObligeeDetails1(@retrofit2.http.Path("externalId") String externalId);

    /**
    * Retrieve a Client
    * Example Requests:  clients/1   clients/1?template&#x3D;true   clients/1?fields&#x3D;id,displayName,officeName
        * @param clientId clientId (required)
        * @param staffInSelectedOfficeOnly staffInSelectedOfficeOnly (optional, default to false)
    * @return Call&lt;GetClientsClientIdResponse&gt;
    */
    @GET("v1/clients/{clientId}")
    Call<GetClientsClientIdResponse> retrieveOne11(@retrofit2.http.Path("clientId") Long clientId, @retrofit2.http.Query("staffInSelectedOfficeOnly") Boolean staffInSelectedOfficeOnly);

    /**
    * Retrieve a Client by External Id
    * Example Requests:  clients/123-456   clients/123-456?template&#x3D;true   clients/123-456?fields&#x3D;id,displayName,officeName
        * @param externalId externalId (required)
        * @param staffInSelectedOfficeOnly staffInSelectedOfficeOnly (optional, default to false)
    * @return Call&lt;GetClientsClientIdResponse&gt;
    */
    @GET("v1/clients/external-id/{externalId}")
    Call<GetClientsClientIdResponse> retrieveOne12(@retrofit2.http.Path("externalId") String externalId, @retrofit2.http.Query("staffInSelectedOfficeOnly") Boolean staffInSelectedOfficeOnly);

    /**
    * Retrieve Client Details Template
    * This is a convenience resource. It can be useful when building maintenance user interface screens for client applications. The template data returned consists of any or all of:  Field Defaults Allowed Value Lists  Example Request:  clients/template
        * @param officeId officeId (optional)
        * @param commandParam commandParam (optional)
        * @param staffInSelectedOfficeOnly staffInSelectedOfficeOnly (optional, default to false)
    * @return Call&lt;GetClientsTemplateResponse&gt;
    */
    @GET("v1/clients/template")
    Call<GetClientsTemplateResponse> retrieveTemplate5(@retrofit2.http.Query("officeId") Long officeId, @retrofit2.http.Query("commandParam") String commandParam, @retrofit2.http.Query("staffInSelectedOfficeOnly") Boolean staffInSelectedOfficeOnly);

    /**
    * Retrieve client transfer template
    * Retrieve client transfer template
        * @param clientId  (required)
    * @return Call&lt;GetClientTransferProposalDateResponse&gt;
    */
    @GET("v1/clients/{clientId}/transferproposaldate")
    Call<GetClientTransferProposalDateResponse> retrieveTransferTemplate(@retrofit2.http.Path("clientId") Long clientId);

    /**
    * Retrieve client transfer template
    * Retrieve client transfer template using the client external Id
        * @param externalId  (required)
    * @return Call&lt;GetClientTransferProposalDateResponse&gt;
    */
    @GET("v1/clients/external-id/{externalId}/transferproposaldate")
    Call<GetClientTransferProposalDateResponse> retrieveTransferTemplate1(@retrofit2.http.Path("externalId") String externalId);

    /**
    * Update a Client
    * Note: You can update any of the basic attributes of a client (but not its associations) using this API.  Changing the relationship between a client and its office is not supported through this API. An API specific to handling transfers of clients between offices is available for the same.  The relationship between a client and a group must be removed through the Groups API.
        * @param clientId clientId (required)
        * @param putClientsClientIdRequest  (required)
    * @return Call&lt;PutClientsClientIdResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @PUT("v1/clients/{clientId}")
    Call<PutClientsClientIdResponse> update10(@retrofit2.http.Path("clientId") Long clientId, @retrofit2.http.Body PutClientsClientIdRequest putClientsClientIdRequest);

    /**
    * Update a Client using the External Id
    * Note: You can update any of the basic attributes of a client (but not its associations) using this API.  Changing the relationship between a client and its office is not supported through this API. An API specific to handling transfers of clients between offices is available for the same.  The relationship between a client and a group must be removed through the Groups API.
        * @param externalId externalId (required)
        * @param putClientsClientIdRequest  (required)
    * @return Call&lt;PutClientsClientIdResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @PUT("v1/clients/external-id/{externalId}")
    Call<PutClientsClientIdResponse> update11(@retrofit2.http.Path("externalId") String externalId, @retrofit2.http.Body PutClientsClientIdRequest putClientsClientIdRequest);



        /**
        * Activate a Client | Close a Client | Reject a Client | Withdraw a Client | Reactivate a Client | UndoReject a Client | UndoWithdraw a Client | Assign a Staff | Unassign a Staff | Update Default Savings Account | Propose a Client Transfer | Withdraw a Client Transfer | Reject a Client Transfer | Accept a Client Transfer | Propose and Accept a Client Transfer
        * Activate a Client:  Clients can be created in a Pending state. This API exists to enable client activation (for when a client becomes an approved member of the financial Institution).  If the client happens to be already active this API will result in an error.  Close a Client:  Clients can be closed if they do not have any non-closed loans/savingsAccount. This API exists to close a client .  If the client have any active loans/savingsAccount this API will result in an error.  Reject a Client:  Clients can be rejected when client is in pending for activation status.  If the client is any other status, this API throws an error.  Mandatory Fields: rejectionDate, rejectionReasonId  Withdraw a Client:  Client applications can be withdrawn when client is in a pending for activation status.  If the client is any other status, this API throws an error.  Mandatory Fields: withdrawalDate, withdrawalReasonId  Reactivate a Client: Clients can be reactivated after they have been closed.  Trying to reactivate a client in any other state throws an error.  Mandatory Fields: reactivationDate  UndoReject a Client:  Clients can be reactivated after they have been rejected.  Trying to reactivate a client in any other state throws an error.  Mandatory Fields: reopenedDateUndoWithdraw a Client:  Clients can be reactivated after they have been withdrawn.  Trying to reactivate a client in any other state throws an error.  Mandatory Fields: reopenedDate  Assign a Staff:  Allows you to assign a Staff for existed Client.  The selected Staff should belong to the same office (or an officer higher up in the hierarchy) as the Client he manages.  Unassign a Staff:  Allows you to unassign the Staff assigned to a Client.  Update Default Savings Account:  Allows you to modify or assign a default savings account for an existing Client.  The selected savings account should be one among the existing savings account for a particular customer.  Propose a Client Transfer:  Allows you to propose the transfer of a Client to a different Office.  Withdraw a Client Transfer:  Allows you to withdraw the proposed transfer of a Client to a different Office.  Withdrawal can happen only if the destination Branch (to which the transfer was proposed) has not already accepted the transfer proposal  Reject a Client Transfer:  Allows the Destination Branch to reject the proposed Client Transfer.  Accept a Client Transfer:  Allows the Destination Branch to accept the proposed Client Transfer.  The destination branch may also choose to link this client to a group (in which case, any existing active JLG loan of the client is rescheduled to match the meeting frequency of the group) and loan Officer at the time of accepting the transfer  Propose and Accept a Client Transfer:  Abstraction over the Propose and Accept Client Transfer API&#39;s which enable a user with Data Scope over both the Target and Destination Branches to directly transfer a Client to the destination Office.  Showing request/response for &#39;Reject a Client Transfer&#39;
            * @param clientId clientId (required)
            * @param postClientsClientIdRequest  (required)
            * @param command command (optional)
        * @return Call&lt;PostClientsClientIdResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/clients/{clientId}")
    Call<PostClientsClientIdResponse> activate1(@retrofit2.http.Path("clientId") Long clientId, @retrofit2.http.Body PostClientsClientIdRequest postClientsClientIdRequest, @retrofit2.http.Query("command") String command, @HeaderMap Map<String, String> headers);

        /**
        * Activate a Client | Close a Client | Reject a Client | Withdraw a Client | Reactivate a Client | UndoReject a Client | UndoWithdraw a Client | Assign a Staff | Unassign a Staff | Update Default Savings Account | Propose a Client Transfer | Withdraw a Client Transfer | Reject a Client Transfer | Accept a Client Transfer | Propose and Accept a Client Transfer
        * Activate a Client:  Clients can be created in a Pending state. This API exists to enable client activation (for when a client becomes an approved member of the financial Institution).  If the client happens to be already active this API will result in an error.  Close a Client:  Clients can be closed if they do not have any non-closed loans/savingsAccount. This API exists to close a client .  If the client have any active loans/savingsAccount this API will result in an error.  Reject a Client:  Clients can be rejected when client is in pending for activation status.  If the client is any other status, this API throws an error.  Mandatory Fields: rejectionDate, rejectionReasonId  Withdraw a Client:  Client applications can be withdrawn when client is in a pending for activation status.  If the client is any other status, this API throws an error.  Mandatory Fields: withdrawalDate, withdrawalReasonId  Reactivate a Client: Clients can be reactivated after they have been closed.  Trying to reactivate a client in any other state throws an error.  Mandatory Fields: reactivationDate  UndoReject a Client:  Clients can be reactivated after they have been rejected.  Trying to reactivate a client in any other state throws an error.  Mandatory Fields: reopenedDateUndoWithdraw a Client:  Clients can be reactivated after they have been withdrawn.  Trying to reactivate a client in any other state throws an error.  Mandatory Fields: reopenedDate  Assign a Staff:  Allows you to assign a Staff for existed Client.  The selected Staff should belong to the same office (or an officer higher up in the hierarchy) as the Client he manages.  Unassign a Staff:  Allows you to unassign the Staff assigned to a Client.  Update Default Savings Account:  Allows you to modify or assign a default savings account for an existing Client.  The selected savings account should be one among the existing savings account for a particular customer.  Propose a Client Transfer:  Allows you to propose the transfer of a Client to a different Office.  Withdraw a Client Transfer:  Allows you to withdraw the proposed transfer of a Client to a different Office.  Withdrawal can happen only if the destination Branch (to which the transfer was proposed) has not already accepted the transfer proposal  Reject a Client Transfer:  Allows the Destination Branch to reject the proposed Client Transfer.  Accept a Client Transfer:  Allows the Destination Branch to accept the proposed Client Transfer.  The destination branch may also choose to link this client to a group (in which case, any existing active JLG loan of the client is rescheduled to match the meeting frequency of the group) and loan Officer at the time of accepting the transfer  Propose and Accept a Client Transfer:  Abstraction over the Propose and Accept Client Transfer API&#39;s which enable a user with Data Scope over both the Target and Destination Branches to directly transfer a Client to the destination Office.  Showing request/response for &#39;Reject a Client Transfer&#39;
            * @param externalId externalId (required)
            * @param postClientsClientIdRequest  (required)
            * @param command command (optional)
        * @return Call&lt;PostClientsClientIdResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/clients/external-id/{externalId}")
    Call<PostClientsClientIdResponse> applyCommand(@retrofit2.http.Path("externalId") String externalId, @retrofit2.http.Body PostClientsClientIdRequest postClientsClientIdRequest, @retrofit2.http.Query("command") String command, @HeaderMap Map<String, String> headers);

        /**
        * Create a Client
        * Note:  1. You can enter either:firstname/middlename/lastname - for a person (middlename is optional) OR fullname - for a business or organisation (or person known by one name).  2.If address is enable(enable-address&#x3D;true), then additional field called address has to be passed.  Mandatory Fields: firstname and lastname OR fullname, officeId, active&#x3D;true and activationDate OR active&#x3D;false, if(address enabled) address  Optional Fields: groupId, externalId, accountNo, staffId, mobileNo, savingsProductId, genderId, clientTypeId, clientClassificationId
            * @param postClientsRequest  (required)
        * @return Call&lt;PostClientsResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/clients")
    Call<PostClientsResponse> create6(@retrofit2.http.Body PostClientsRequest postClientsRequest, @HeaderMap Map<String, String> headers);

        /**
        * Delete a Client
        * If a client is in Pending state, you are allowed to Delete it. The delete is a &#39;hard delete&#39; and cannot be recovered from. Once clients become active or have loans or savings associated with them, you cannot delete the client but you may Close the client if they have left the program.
            * @param clientId clientId (required)
        * @return Call&lt;DeleteClientsClientIdResponse&gt;
        */
    @DELETE("v1/clients/{clientId}")
    Call<DeleteClientsClientIdResponse> delete8(@retrofit2.http.Path("clientId") Long clientId, @HeaderMap Map<String, String> headers);

        /**
        * Delete a Client
        * If a client is in Pending state, you are allowed to Delete it. The delete is a &#39;hard delete&#39; and cannot be recovered from. Once clients become active or have loans or savings associated with them, you cannot delete the client but you may Close the client if they have left the program.
            * @param externalId externalId (required)
        * @return Call&lt;DeleteClientsClientIdResponse&gt;
        */
    @DELETE("v1/clients/external-id/{externalId}")
    Call<DeleteClientsClientIdResponse> delete9(@retrofit2.http.Path("externalId") String externalId, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param legalFormType  (optional)
            * @param officeId  (optional)
            * @param staffId  (optional)
            * @param dateFormat  (optional)
        * @return Call&lt;Void&gt;
        */
    @GET("v1/clients/downloadtemplate")
    Call<Void> getClientTemplate(@retrofit2.http.Query("legalFormType") String legalFormType, @retrofit2.http.Query("officeId") Long officeId, @retrofit2.http.Query("staffId") Long staffId, @retrofit2.http.Query("dateFormat") String dateFormat, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param legalFormType  (optional)
            * @param dateFormat  (optional)
            * @param locale  (optional)
            * @param uploadedInputStream  (optional)
        * @return Call&lt;String&gt;
        */
            @retrofit2.http.Multipart
    @POST("v1/clients/uploadtemplate")
    Call<String> postClientTemplate(@retrofit2.http.Query("legalFormType") String legalFormType, @retrofit2.http.Part("dateFormat") String dateFormat, @retrofit2.http.Part("locale") String locale, @retrofit2.http.Part MultipartBody.Part uploadedInputStream, @HeaderMap Map<String, String> headers);

        /**
        * List Clients
        * The list capability of clients can support pagination and sorting.  Example Requests:  clients  clients?fields&#x3D;displayName,officeName,timeline  clients?offset&#x3D;10&amp;limit&#x3D;50  clients?orderBy&#x3D;displayName&amp;sortOrder&#x3D;DESC
            * @param officeId officeId (optional)
            * @param externalId externalId (optional)
            * @param displayName displayName (optional)
            * @param firstName firstName (optional)
            * @param lastName lastName (optional)
            * @param status status (optional)
            * @param underHierarchy underHierarchy (optional)
            * @param offset offset (optional)
            * @param limit limit (optional)
            * @param orderBy orderBy (optional)
            * @param sortOrder sortOrder (optional)
            * @param orphansOnly orphansOnly (optional)
            * @param legalForm  (optional)
        * @return Call&lt;GetClientsResponse&gt;
        */
    @GET("v1/clients")
    Call<GetClientsResponse> retrieveAll21(@retrofit2.http.Query("officeId") Long officeId, @retrofit2.http.Query("externalId") String externalId, @retrofit2.http.Query("displayName") String displayName, @retrofit2.http.Query("firstName") String firstName, @retrofit2.http.Query("lastName") String lastName, @retrofit2.http.Query("status") String status, @retrofit2.http.Query("underHierarchy") String underHierarchy, @retrofit2.http.Query("offset") Integer offset, @retrofit2.http.Query("limit") Integer limit, @retrofit2.http.Query("orderBy") String orderBy, @retrofit2.http.Query("sortOrder") String sortOrder, @retrofit2.http.Query("orphansOnly") Boolean orphansOnly, @retrofit2.http.Query("legalForm") Integer legalForm, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve client accounts overview
        * An example of how a loan portfolio summary can be provided. This is requested in a specific use case of the community application. It is quite reasonable to add resources like this to simplify User Interface development.  Example Requests:   clients/1/accounts  clients/1/accounts?fields&#x3D;loanAccounts,savingsAccounts
            * @param clientId clientId (required)
        * @return Call&lt;GetClientsClientIdAccountsResponse&gt;
        */
    @GET("v1/clients/{clientId}/accounts")
    Call<GetClientsClientIdAccountsResponse> retrieveAssociatedAccounts(@retrofit2.http.Path("clientId") Long clientId, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve client accounts overview
        * An example of how a loan portfolio summary can be provided. This is requested in a specific use case of the community application. It is quite reasonable to add resources like this to simplify User Interface development.  Example Requests:   clients/123-456/accounts  clients/123-456/accounts?fields&#x3D;loanAccounts,savingsAccounts
            * @param externalId externalId (required)
        * @return Call&lt;GetClientsClientIdAccountsResponse&gt;
        */
    @GET("v1/clients/external-id/{externalId}/accounts")
    Call<GetClientsClientIdAccountsResponse> retrieveAssociatedAccounts1(@retrofit2.http.Path("externalId") String externalId, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve client obligee details
        * Retrieve client obligee details
            * @param clientId  (required)
        * @return Call&lt;GetClientObligeeDetailsResponse&gt;
        */
    @GET("v1/clients/{clientId}/obligeedetails")
    Call<GetClientObligeeDetailsResponse> retrieveObligeeDetails(@retrofit2.http.Path("clientId") Long clientId, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve client obligee details
        * Retrieve client obligee details using the client external Id
            * @param externalId  (required)
        * @return Call&lt;GetClientObligeeDetailsResponse&gt;
        */
    @GET("v1/clients/external-id/{externalId}/obligeedetails")
    Call<GetClientObligeeDetailsResponse> retrieveObligeeDetails1(@retrofit2.http.Path("externalId") String externalId, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve a Client
        * Example Requests:  clients/1   clients/1?template&#x3D;true   clients/1?fields&#x3D;id,displayName,officeName
            * @param clientId clientId (required)
            * @param staffInSelectedOfficeOnly staffInSelectedOfficeOnly (optional, default to false)
        * @return Call&lt;GetClientsClientIdResponse&gt;
        */
    @GET("v1/clients/{clientId}")
    Call<GetClientsClientIdResponse> retrieveOne11(@retrofit2.http.Path("clientId") Long clientId, @retrofit2.http.Query("staffInSelectedOfficeOnly") Boolean staffInSelectedOfficeOnly, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve a Client by External Id
        * Example Requests:  clients/123-456   clients/123-456?template&#x3D;true   clients/123-456?fields&#x3D;id,displayName,officeName
            * @param externalId externalId (required)
            * @param staffInSelectedOfficeOnly staffInSelectedOfficeOnly (optional, default to false)
        * @return Call&lt;GetClientsClientIdResponse&gt;
        */
    @GET("v1/clients/external-id/{externalId}")
    Call<GetClientsClientIdResponse> retrieveOne12(@retrofit2.http.Path("externalId") String externalId, @retrofit2.http.Query("staffInSelectedOfficeOnly") Boolean staffInSelectedOfficeOnly, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve Client Details Template
        * This is a convenience resource. It can be useful when building maintenance user interface screens for client applications. The template data returned consists of any or all of:  Field Defaults Allowed Value Lists  Example Request:  clients/template
            * @param officeId officeId (optional)
            * @param commandParam commandParam (optional)
            * @param staffInSelectedOfficeOnly staffInSelectedOfficeOnly (optional, default to false)
        * @return Call&lt;GetClientsTemplateResponse&gt;
        */
    @GET("v1/clients/template")
    Call<GetClientsTemplateResponse> retrieveTemplate5(@retrofit2.http.Query("officeId") Long officeId, @retrofit2.http.Query("commandParam") String commandParam, @retrofit2.http.Query("staffInSelectedOfficeOnly") Boolean staffInSelectedOfficeOnly, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve client transfer template
        * Retrieve client transfer template
            * @param clientId  (required)
        * @return Call&lt;GetClientTransferProposalDateResponse&gt;
        */
    @GET("v1/clients/{clientId}/transferproposaldate")
    Call<GetClientTransferProposalDateResponse> retrieveTransferTemplate(@retrofit2.http.Path("clientId") Long clientId, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve client transfer template
        * Retrieve client transfer template using the client external Id
            * @param externalId  (required)
        * @return Call&lt;GetClientTransferProposalDateResponse&gt;
        */
    @GET("v1/clients/external-id/{externalId}/transferproposaldate")
    Call<GetClientTransferProposalDateResponse> retrieveTransferTemplate1(@retrofit2.http.Path("externalId") String externalId, @HeaderMap Map<String, String> headers);

        /**
        * Update a Client
        * Note: You can update any of the basic attributes of a client (but not its associations) using this API.  Changing the relationship between a client and its office is not supported through this API. An API specific to handling transfers of clients between offices is available for the same.  The relationship between a client and a group must be removed through the Groups API.
            * @param clientId clientId (required)
            * @param putClientsClientIdRequest  (required)
        * @return Call&lt;PutClientsClientIdResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/clients/{clientId}")
    Call<PutClientsClientIdResponse> update10(@retrofit2.http.Path("clientId") Long clientId, @retrofit2.http.Body PutClientsClientIdRequest putClientsClientIdRequest, @HeaderMap Map<String, String> headers);

        /**
        * Update a Client using the External Id
        * Note: You can update any of the basic attributes of a client (but not its associations) using this API.  Changing the relationship between a client and its office is not supported through this API. An API specific to handling transfers of clients between offices is available for the same.  The relationship between a client and a group must be removed through the Groups API.
            * @param externalId externalId (required)
            * @param putClientsClientIdRequest  (required)
        * @return Call&lt;PutClientsClientIdResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/clients/external-id/{externalId}")
    Call<PutClientsClientIdResponse> update11(@retrofit2.http.Path("externalId") String externalId, @retrofit2.http.Body PutClientsClientIdRequest putClientsClientIdRequest, @HeaderMap Map<String, String> headers);


}
