/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table.batch;

import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedHashMap;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.connector.file.table.FileSystemFactory;
import org.apache.flink.connector.file.table.FileSystemOutputFormat;
import org.apache.flink.connector.file.table.PartitionCommitPolicyFactory;
import org.apache.flink.connector.file.table.TableMetaStoreFactory;
import org.apache.flink.connector.file.table.batch.compact.BatchCompactCoordinator;
import org.apache.flink.connector.file.table.batch.compact.BatchCompactOperator;
import org.apache.flink.connector.file.table.batch.compact.BatchPartitionCommitterSink;
import org.apache.flink.connector.file.table.stream.compact.CompactBucketWriter;
import org.apache.flink.connector.file.table.stream.compact.CompactMessages;
import org.apache.flink.connector.file.table.stream.compact.CompactReader;
import org.apache.flink.connector.file.table.stream.compact.CompactWriter;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.functions.sink.filesystem.StreamingFileSink;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.data.RowData;
import org.apache.flink.types.Row;
import org.apache.flink.util.function.SupplierWithException;

@Internal
public class BatchSink {
    public static final String COORDINATOR_OP_NAME = "compact-coordinator";
    public static final String COMPACT_OP_NAME = "compact-operator";

    private BatchSink() {
    }

    public static DataStreamSink<Row> createBatchNoCompactSink(DataStream<RowData> dataStream, DynamicTableSink.DataStructureConverter converter, FileSystemOutputFormat<Row> fileSystemOutputFormat, int parallelism, boolean parallelismConfigured) {
        SingleOutputStreamOperator map = dataStream.map((MapFunction & Serializable)value -> (Row)converter.toExternal(value));
        map.getTransformation().setParallelism(parallelism, parallelismConfigured);
        DataStreamSink sink = map.writeUsingOutputFormat(fileSystemOutputFormat);
        sink.getTransformation().setParallelism(parallelism, parallelismConfigured);
        return sink;
    }

    public static <T> DataStreamSink<?> createBatchCompactSink(DataStream<CompactMessages.CoordinatorInput> dataStream, StreamingFileSink.BucketsBuilder<T, String, ? extends StreamingFileSink.BucketsBuilder<T, String, ?>> builder, CompactReader.Factory<T> readFactory, FileSystemFactory fsFactory, TableMetaStoreFactory metaStoreFactory, PartitionCommitPolicyFactory partitionCommitPolicyFactory, String[] partitionColumns, LinkedHashMap<String, String> staticPartitionSpec, Path tmpPath, ObjectIdentifier identifier, long compactAverageSize, long compactTargetSize, boolean isToLocal, boolean overwrite, int compactParallelism, boolean compactParallelismConfigured) {
        SupplierWithException fsSupplier = (SupplierWithException & Serializable)() -> fsFactory.create(tmpPath.toUri());
        CompactWriter.Factory writerFactory = CompactBucketWriter.factory(() -> builder.createBucketWriter());
        SingleOutputStreamOperator transform = dataStream.transform(COORDINATOR_OP_NAME, TypeInformation.of(CompactMessages.CoordinatorOutput.class), (OneInputStreamOperator)new BatchCompactCoordinator((SupplierWithException<FileSystem, IOException>)fsSupplier, compactAverageSize, compactTargetSize)).setParallelism(1).setMaxParallelism(1).transform(COMPACT_OP_NAME, TypeInformation.of(CompactMessages.CompactOutput.class), new BatchCompactOperator<T>((SupplierWithException<FileSystem, IOException>)fsSupplier, readFactory, writerFactory));
        transform.getTransformation().setParallelism(compactParallelism, compactParallelismConfigured);
        return transform.addSink((SinkFunction)new BatchPartitionCommitterSink(fsFactory, metaStoreFactory, overwrite, isToLocal, tmpPath, partitionColumns, staticPartitionSpec, identifier, partitionCommitPolicyFactory)).setParallelism(1);
    }
}

