/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.util.collections.binary;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.runtime.util.LazyMemorySegmentPool;
import org.apache.flink.util.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BytesMap<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(BytesMap.class);
    public static final int BUCKET_SIZE = 8;
    protected static final int END_OF_LIST = Integer.MAX_VALUE;
    protected static final int STEP_INCREMENT = 1;
    protected static final int ELEMENT_POINT_LENGTH = 4;
    public static final int RECORD_EXTRA_LENGTH = 8;
    protected static final int BUCKET_SIZE_BITS = 3;
    protected final int numBucketsPerSegment;
    protected final int numBucketsPerSegmentBits;
    protected final int numBucketsPerSegmentMask;
    protected final int lastBucketPosition;
    protected final int segmentSize;
    protected final LazyMemorySegmentPool memoryPool;
    protected List<MemorySegment> bucketSegments;
    protected final int reservedNumBuffers;
    protected long numElements = 0L;
    protected int numBucketsMask;
    protected int log2NumBuckets;
    protected int numBucketsMask2;
    protected static final double LOAD_FACTOR = 0.75;
    protected static final long INIT_BUCKET_MEMORY_IN_BYTES = 0x100000L;
    protected int growthThreshold;
    protected RecordArea<K, V> recordArea;
    protected K reusedKey;
    protected V reusedValue;
    private final LookupInfo<K, V> reuseLookupInfo;
    protected long numSpillFiles;
    protected long spillInBytes;

    public BytesMap(Object owner, MemoryManager memoryManager, long memorySize, TypeSerializer<K> keySerializer) {
        int maxPages = (int)(memorySize / (long)memoryManager.getPageSize());
        this.memoryPool = new LazyMemorySegmentPool(owner, memoryManager, maxPages);
        this.segmentSize = this.memoryPool.pageSize();
        this.reservedNumBuffers = (int)(memorySize / (long)this.segmentSize);
        this.numBucketsPerSegment = this.segmentSize / 8;
        this.numBucketsPerSegmentBits = MathUtils.log2strict((int)this.numBucketsPerSegment);
        this.numBucketsPerSegmentMask = (1 << this.numBucketsPerSegmentBits) - 1;
        this.lastBucketPosition = (this.numBucketsPerSegment - 1) * 8;
        this.reusedKey = keySerializer.createInstance();
        this.reuseLookupInfo = new LookupInfo();
    }

    public abstract long getNumKeys();

    protected void initBucketSegments(int numBucketSegments) {
        if (numBucketSegments < 1) {
            throw new RuntimeException("Too small memory allocated for BytesHashMap");
        }
        this.bucketSegments = new ArrayList<MemorySegment>(numBucketSegments);
        for (int i = 0; i < numBucketSegments; ++i) {
            this.bucketSegments.add(i, this.memoryPool.nextSegment());
        }
        this.resetBucketSegments(this.bucketSegments);
        int numBuckets = numBucketSegments * this.numBucketsPerSegment;
        this.log2NumBuckets = MathUtils.log2strict((int)numBuckets);
        this.numBucketsMask = (1 << MathUtils.log2strict((int)numBuckets)) - 1;
        this.numBucketsMask2 = (1 << MathUtils.log2strict((int)(numBuckets >> 1))) - 1;
        this.growthThreshold = (int)((double)numBuckets * 0.75);
    }

    protected void resetBucketSegments(List<MemorySegment> resetBucketSegs) {
        for (MemorySegment segment : resetBucketSegs) {
            for (int j = 0; j <= this.lastBucketPosition; j += 8) {
                segment.putInt(j, Integer.MAX_VALUE);
            }
        }
    }

    public long getNumSpillFiles() {
        return this.numSpillFiles;
    }

    public long getSpillInBytes() {
        return this.spillInBytes;
    }

    public long getNumElements() {
        return this.numElements;
    }

    public void free(boolean reservedRecordMemory) {
        this.returnSegments(this.bucketSegments);
        this.bucketSegments.clear();
        if (!reservedRecordMemory) {
            this.memoryPool.close();
        }
        this.numElements = 0L;
    }

    public void reset() {
        this.setBucketVariables(this.bucketSegments);
        this.resetBucketSegments(this.bucketSegments);
        this.numElements = 0L;
        LOG.debug("reset BytesHashMap with record memory segments {}, {} in bytes, init allocating {} for bucket area.", new Object[]{this.memoryPool.freePages(), this.memoryPool.freePages() * this.segmentSize, this.bucketSegments.size()});
    }

    public LookupInfo<K, V> lookup(K key) {
        int hashCode1 = key.hashCode();
        int newPos = hashCode1 & this.numBucketsMask;
        int bucketSegmentIndex = newPos >>> this.numBucketsPerSegmentBits;
        int bucketOffset = (newPos & this.numBucketsPerSegmentMask) << 3;
        boolean found = false;
        int step = 1;
        int hashCode2 = 0;
        try {
            int findElementPtr;
            while ((findElementPtr = this.bucketSegments.get(bucketSegmentIndex).getInt(bucketOffset)) != Integer.MAX_VALUE) {
                int storedHashCode = this.bucketSegments.get(bucketSegmentIndex).getInt(bucketOffset + 4);
                if (hashCode1 == storedHashCode) {
                    this.recordArea.setReadPosition(findElementPtr);
                    if (this.recordArea.readKeyAndEquals(key)) {
                        found = true;
                        this.reusedValue = this.recordArea.readValue(this.reusedValue);
                        break;
                    }
                }
                if (step == 1) {
                    hashCode2 = this.calcSecondHashCode(hashCode1);
                }
                newPos = hashCode1 + step * hashCode2 & this.numBucketsMask;
                bucketSegmentIndex = newPos >>> this.numBucketsPerSegmentBits;
                bucketOffset = (newPos & this.numBucketsPerSegmentMask) << 3;
                ++step;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Error reading record from the aggregate map: " + ex.getMessage(), ex);
        }
        this.reuseLookupInfo.set(found, hashCode1, key, this.reusedValue, bucketSegmentIndex, bucketOffset);
        return this.reuseLookupInfo;
    }

    protected void growAndRehash() throws EOFException {
        int required = 2 * this.bucketSegments.size();
        if ((long)required * (long)this.numBucketsPerSegment > Integer.MAX_VALUE) {
            LOG.warn("We can't handle more than Integer.MAX_VALUE buckets (eg. because hash functions return int)");
            throw new EOFException();
        }
        int numAllocatedSegments = required - this.memoryPool.freePages();
        if (numAllocatedSegments > 0) {
            LOG.warn("BytesHashMap can't allocate {} pages, and now used {} pages", (Object)required, (Object)this.reservedNumBuffers);
            throw new EOFException();
        }
        List<MemorySegment> newBucketSegments = this.memoryPool.allocateSegments(required);
        this.setBucketVariables(newBucketSegments);
        long reHashStartTime = System.currentTimeMillis();
        this.resetBucketSegments(newBucketSegments);
        for (MemorySegment memorySegment : this.bucketSegments) {
            for (int j = 0; j < this.numBucketsPerSegment; ++j) {
                int recordPointer = memorySegment.getInt(j * 8);
                if (recordPointer == Integer.MAX_VALUE) continue;
                int hashCode1 = memorySegment.getInt(j * 8 + 4);
                int newPos = hashCode1 & this.numBucketsMask;
                int bucketSegmentIndex = newPos >>> this.numBucketsPerSegmentBits;
                int bucketOffset = (newPos & this.numBucketsPerSegmentMask) << 3;
                int step = 1;
                long hashCode2 = 0L;
                while (newBucketSegments.get(bucketSegmentIndex).getInt(bucketOffset) != Integer.MAX_VALUE) {
                    if (step == 1) {
                        hashCode2 = this.calcSecondHashCode(hashCode1);
                    }
                    newPos = (int)((long)hashCode1 + (long)step * hashCode2 & (long)this.numBucketsMask);
                    bucketSegmentIndex = newPos >>> this.numBucketsPerSegmentBits;
                    bucketOffset = (newPos & this.numBucketsPerSegmentMask) << 3;
                    ++step;
                }
                newBucketSegments.get(bucketSegmentIndex).putInt(bucketOffset, recordPointer);
                newBucketSegments.get(bucketSegmentIndex).putInt(bucketOffset + 4, hashCode1);
            }
        }
        LOG.info("The rehash take {} ms for {} segments", (Object)(System.currentTimeMillis() - reHashStartTime), (Object)required);
        this.memoryPool.returnAll(this.bucketSegments);
        this.bucketSegments = newBucketSegments;
    }

    protected void returnSegments(List<MemorySegment> segments) {
        this.memoryPool.returnAll(segments);
    }

    private void setBucketVariables(List<MemorySegment> bucketSegments) {
        int numBuckets = bucketSegments.size() * this.numBucketsPerSegment;
        this.log2NumBuckets = MathUtils.log2strict((int)numBuckets);
        this.numBucketsMask = (1 << MathUtils.log2strict((int)numBuckets)) - 1;
        this.numBucketsMask2 = (1 << MathUtils.log2strict((int)(numBuckets >> 1))) - 1;
        this.growthThreshold = (int)((double)numBuckets * 0.75);
    }

    protected int calcSecondHashCode(int firstHashCode) {
        return ((firstHashCode >> this.log2NumBuckets & this.numBucketsMask2) << 1) + 1;
    }

    public static final class LookupInfo<K, V> {
        boolean found = false;
        K key = null;
        V value = null;
        int keyHashCode = -1;
        int bucketSegmentIndex = -1;
        int bucketOffset = -1;

        LookupInfo() {
        }

        void set(boolean found, int keyHashCode, K key, V value, int bucketSegmentIndex, int bucketOffset) {
            this.found = found;
            this.keyHashCode = keyHashCode;
            this.key = key;
            this.value = value;
            this.bucketSegmentIndex = bucketSegmentIndex;
            this.bucketOffset = bucketOffset;
        }

        public boolean isFound() {
            return this.found;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }
    }

    static interface RecordArea<K, V> {
        public void setReadPosition(int var1);

        public boolean readKeyAndEquals(K var1) throws IOException;

        public V readValue(V var1) throws IOException;

        public int appendRecord(LookupInfo<K, V> var1, BinaryRowData var2) throws IOException;

        public long getSegmentsSize();

        public void release();

        public void reset();
    }
}

