/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.Strong;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.ImmutableJoinDeriveIsNotNullFilterRule;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.immutables.value.Value;

@Value.Enclosing
public class JoinDeriveIsNotNullFilterRule
extends RelRule<Config>
implements TransformationRule {
    public JoinDeriveIsNotNullFilterRule(Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Join join = (Join)call.rel(0);
        RelBuilder relBuilder = call.builder();
        RelMetadataQuery mq = call.getMetadataQuery();
        ImmutableBitSet.Builder notNullableKeys = ImmutableBitSet.builder();
        RelOptUtil.conjunctions(join.getCondition()).forEach(node -> {
            if (Strong.isStrong(node)) {
                notNullableKeys.addAll(RelOptUtil.InputFinder.bits(node));
            }
        });
        ArrayList leftKeys = new ArrayList();
        ArrayList rightKeys = new ArrayList();
        int offset = join.getLeft().getRowType().getFieldCount();
        notNullableKeys.build().asList().forEach(i -> {
            if (i < offset) {
                leftKeys.add(i);
            } else {
                rightKeys.add(i - offset);
            }
        });
        relBuilder.push(join.getLeft()).withPredicates(mq, r -> r.filter(leftKeys.stream().map(r::field).map(r::isNotNull).collect(Collectors.toList())));
        RelNode newLeft = relBuilder.build();
        relBuilder.push(join.getRight()).withPredicates(mq, r -> r.filter(rightKeys.stream().map(r::field).map(r::isNotNull).collect(Collectors.toList())));
        RelNode newRight = relBuilder.build();
        if (newLeft != join.getLeft() || newRight != join.getRight()) {
            RelNode newJoin = join.copy(join.getTraitSet(), ImmutableList.of(newLeft, newRight));
            call.transformTo(newJoin);
        }
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final ImmutableJoinDeriveIsNotNullFilterRule.Config DEFAULT = ImmutableJoinDeriveIsNotNullFilterRule.Config.of().withOperandSupplier(b -> b.operand(LogicalJoin.class).predicate(join -> join.getJoinType() == JoinRelType.INNER && !join.getCondition().isAlwaysTrue()).anyInputs());

        @Override
        default public JoinDeriveIsNotNullFilterRule toRule() {
            return new JoinDeriveIsNotNullFilterRule(this);
        }
    }
}

