/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table;

import java.io.IOException;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.connector.file.src.util.RecordMapperWrapperRecordIterator;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.ProjectedRowData;

class ProjectingBulkFormat
implements BulkFormat<RowData, FileSourceSplit> {
    private final BulkFormat<RowData, FileSourceSplit> wrapped;
    private final TypeInformation<RowData> producedType;
    private final int[] projections;

    public ProjectingBulkFormat(BulkFormat<RowData, FileSourceSplit> wrapped, int[] projections, TypeInformation<RowData> producedType) {
        this.wrapped = wrapped;
        this.projections = projections;
        this.producedType = producedType;
    }

    @Override
    public BulkFormat.Reader<RowData> createReader(Configuration config, FileSourceSplit split) throws IOException {
        return this.wrapReader(this.wrapped.createReader(config, split), split);
    }

    @Override
    public BulkFormat.Reader<RowData> restoreReader(Configuration config, FileSourceSplit split) throws IOException {
        return this.wrapReader(this.wrapped.restoreReader(config, split), split);
    }

    @Override
    public boolean isSplittable() {
        return this.wrapped.isSplittable();
    }

    @Override
    public TypeInformation<RowData> getProducedType() {
        return this.producedType;
    }

    private BulkFormat.Reader<RowData> wrapReader(BulkFormat.Reader<RowData> superReader, FileSourceSplit split) {
        ProjectedRowData producedRowData = ProjectedRowData.from((int[])this.projections);
        return RecordMapperWrapperRecordIterator.wrapReader(superReader, physicalRowData -> {
            producedRowData.replaceRow(physicalRowData);
            return producedRowData;
        });
    }
}

