/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.sftp.SFTPConnectionPool;
import org.apache.hadoop.fs.sftp.SFTPInputStream;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SFTPFileSystem
extends FileSystem {
    public static final Logger LOG = LoggerFactory.getLogger(SFTPFileSystem.class);
    private SFTPConnectionPool connectionPool;
    private URI uri;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private static final int DEFAULT_SFTP_PORT = 22;
    private static final int DEFAULT_MAX_CONNECTION = 5;
    public static final int DEFAULT_BUFFER_SIZE = 0x100000;
    public static final int DEFAULT_BLOCK_SIZE = 4096;
    public static final String FS_SFTP_USER_PREFIX = "fs.sftp.user.";
    public static final String FS_SFTP_PASSWORD_PREFIX = "fs.sftp.password.";
    public static final String FS_SFTP_HOST = "fs.sftp.host";
    public static final String FS_SFTP_HOST_PORT = "fs.sftp.host.port";
    public static final String FS_SFTP_KEYFILE = "fs.sftp.keyfile";
    public static final String FS_SFTP_CONNECTION_MAX = "fs.sftp.connection.max";
    public static final String E_SAME_DIRECTORY_ONLY = "only same directory renames are supported";
    public static final String E_HOST_NULL = "Invalid host specified";
    public static final String E_USER_NULL = "No user specified for sftp connection. Expand URI or credential file.";
    public static final String E_PATH_DIR = "Path %s is a directory.";
    public static final String E_FILE_STATUS = "Failed to get file status";
    public static final String E_FILE_NOTFOUND = "File %s does not exist.";
    public static final String E_FILE_EXIST = "File already exists: %s";
    public static final String E_CREATE_DIR = "create(): Mkdirs failed to create: %s";
    public static final String E_DIR_CREATE_FROMFILE = "Can't make directory for path %s since it is a file.";
    public static final String E_MAKE_DIR_FORPATH = "Can't make directory for path \"%s\" under \"%s\".";
    public static final String E_DIR_NOTEMPTY = "Directory: %s is not empty.";
    public static final String E_FILE_CHECK_FAILED = "File check failed";
    public static final String E_SPATH_NOTEXIST = "Source path %s does not exist";
    public static final String E_DPATH_EXIST = "Destination path %s already exist, cannot rename!";
    public static final String E_FAILED_GETHOME = "Failed to get home directory";
    public static final String E_FAILED_DISCONNECT = "Failed to disconnect";
    public static final String E_FS_CLOSED = "FileSystem is closed!";

    private void setConfigurationFromURI(URI uriInfo, Configuration conf) throws IOException {
        String user;
        String host = uriInfo.getHost();
        String string = host = host == null ? conf.get(FS_SFTP_HOST, null) : host;
        if (host == null) {
            throw new IOException(E_HOST_NULL);
        }
        conf.set(FS_SFTP_HOST, host);
        int port = uriInfo.getPort();
        port = port == -1 ? conf.getInt(FS_SFTP_HOST_PORT, 22) : port;
        conf.setInt(FS_SFTP_HOST_PORT, port);
        String userAndPwdFromUri = uriInfo.getUserInfo();
        if (userAndPwdFromUri != null) {
            String[] userPasswdInfo = userAndPwdFromUri.split(":");
            String user2 = userPasswdInfo[0];
            user2 = URLDecoder.decode(user2, "UTF-8");
            conf.set(FS_SFTP_USER_PREFIX + host, user2);
            if (userPasswdInfo.length > 1) {
                conf.set(FS_SFTP_PASSWORD_PREFIX + host + "." + user2, userPasswdInfo[1]);
            }
        }
        if ((user = conf.get(FS_SFTP_USER_PREFIX + host)) == null || user.equals("")) {
            throw new IllegalStateException(E_USER_NULL);
        }
        int connectionMax = conf.getInt(FS_SFTP_CONNECTION_MAX, 5);
        this.connectionPool = new SFTPConnectionPool(connectionMax);
    }

    private ChannelSftp connect() throws IOException {
        this.checkNotClosed();
        Configuration conf = this.getConf();
        String host = conf.get(FS_SFTP_HOST, null);
        int port = conf.getInt(FS_SFTP_HOST_PORT, 22);
        String user = conf.get(FS_SFTP_USER_PREFIX + host, null);
        String pwd = conf.get(FS_SFTP_PASSWORD_PREFIX + host + "." + user, null);
        String keyFile = conf.get(FS_SFTP_KEYFILE, null);
        ChannelSftp channel = this.connectionPool.connect(host, port, user, pwd, keyFile);
        return channel;
    }

    private void disconnect(ChannelSftp channel) throws IOException {
        this.connectionPool.disconnect(channel);
    }

    private Path makeAbsolute(Path workDir, Path path) {
        if (path.isAbsolute()) {
            return path;
        }
        return new Path(workDir, path);
    }

    private boolean exists(ChannelSftp channel, Path file) throws IOException {
        try {
            this.getFileStatus(channel, file);
            return true;
        }
        catch (FileNotFoundException fnfe) {
            return false;
        }
        catch (IOException ioe) {
            throw new IOException(E_FILE_STATUS, ioe);
        }
    }

    private FileStatus getFileStatus(ChannelSftp client, Path file) throws IOException {
        Vector sftpFiles;
        Path workDir;
        FileStatus fileStat = null;
        try {
            workDir = new Path(client.pwd());
        }
        catch (SftpException e) {
            throw new IOException(e);
        }
        Path absolute = this.makeAbsolute(workDir, file);
        Path parentPath = absolute.getParent();
        if (parentPath == null) {
            long length = -1L;
            boolean isDir = true;
            int blockReplication = 1;
            long blockSize = 4096L;
            long modTime = -1L;
            Path root = new Path("/");
            return new FileStatus(length, isDir, blockReplication, blockSize, modTime, root.makeQualified(this.getUri(), this.getWorkingDirectory(client)));
        }
        String pathName = parentPath.toUri().getPath();
        try {
            sftpFiles = client.ls(pathName);
        }
        catch (SftpException e) {
            throw new FileNotFoundException(String.format(E_FILE_NOTFOUND, file));
        }
        if (sftpFiles != null) {
            for (ChannelSftp.LsEntry sftpFile : sftpFiles) {
                if (!sftpFile.getFilename().equals(file.getName())) continue;
                fileStat = this.getFileStatus(client, sftpFile, parentPath);
                break;
            }
            if (fileStat == null) {
                throw new FileNotFoundException(String.format(E_FILE_NOTFOUND, file));
            }
        } else {
            throw new FileNotFoundException(String.format(E_FILE_NOTFOUND, file));
        }
        return fileStat;
    }

    private FileStatus getFileStatus(ChannelSftp channel, ChannelSftp.LsEntry sftpFile, Path parentPath) throws IOException {
        SftpATTRS attr = sftpFile.getAttrs();
        long length = attr.getSize();
        boolean isDir = attr.isDir();
        boolean isLink = attr.isLink();
        if (isLink) {
            String link = parentPath.toUri().getPath() + "/" + sftpFile.getFilename();
            try {
                link = channel.realpath(link);
                Path linkParent = new Path("/", link);
                FileStatus fstat = this.getFileStatus(channel, linkParent);
                isDir = fstat.isDirectory();
                length = fstat.getLen();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        int blockReplication = 1;
        long blockSize = 4096L;
        long modTime = (long)attr.getMTime() * 1000L;
        long accessTime = (long)attr.getATime() * 1000L;
        FsPermission permission = this.getPermissions(sftpFile);
        String user = Integer.toString(attr.getUId());
        String group = Integer.toString(attr.getGId());
        Path filePath = new Path(parentPath, sftpFile.getFilename());
        return new FileStatus(length, isDir, blockReplication, blockSize, modTime, accessTime, permission, user, group, filePath.makeQualified(this.getUri(), this.getWorkingDirectory(channel)));
    }

    private FsPermission getPermissions(ChannelSftp.LsEntry sftpFile) {
        return new FsPermission((short)sftpFile.getAttrs().getPermissions());
    }

    private boolean mkdirs(ChannelSftp client, Path file, FsPermission permission) throws IOException {
        Path workDir;
        boolean created = true;
        try {
            workDir = new Path(client.pwd());
        }
        catch (SftpException e) {
            throw new IOException(e);
        }
        Path absolute = this.makeAbsolute(workDir, file);
        String pathName = absolute.getName();
        if (!this.exists(client, absolute)) {
            Path parent = absolute.getParent();
            boolean bl = created = parent == null || this.mkdirs(client, parent, FsPermission.getDefault());
            if (created) {
                String parentDir = parent.toUri().getPath();
                boolean succeeded = true;
                try {
                    String previousCwd = client.pwd();
                    client.cd(parentDir);
                    client.mkdir(pathName);
                    client.cd(previousCwd);
                }
                catch (SftpException e) {
                    throw new IOException(String.format(E_MAKE_DIR_FORPATH, pathName, parentDir));
                }
                created &= succeeded;
            }
        } else if (this.isFile(client, absolute)) {
            throw new IOException(String.format(E_DIR_CREATE_FROMFILE, absolute));
        }
        return created;
    }

    private boolean isFile(ChannelSftp channel, Path file) throws IOException {
        try {
            return !this.getFileStatus(channel, file).isDirectory();
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException ioe) {
            throw new IOException(E_FILE_CHECK_FAILED, ioe);
        }
    }

    private boolean delete(ChannelSftp channel, Path file, boolean recursive) throws IOException {
        Path workDir;
        try {
            workDir = new Path(channel.pwd());
        }
        catch (SftpException e) {
            throw new IOException(e);
        }
        Path absolute = this.makeAbsolute(workDir, file);
        String pathName = absolute.toUri().getPath();
        FileStatus fileStat = null;
        try {
            fileStat = this.getFileStatus(channel, absolute);
        }
        catch (FileNotFoundException e) {
            return false;
        }
        if (!fileStat.isDirectory()) {
            boolean status = true;
            try {
                channel.rm(pathName);
            }
            catch (SftpException e) {
                status = false;
            }
            return status;
        }
        boolean status = true;
        FileStatus[] dirEntries = this.listStatus(channel, absolute);
        if (dirEntries != null && dirEntries.length > 0) {
            if (!recursive) {
                throw new IOException(String.format(E_DIR_NOTEMPTY, file));
            }
            for (int i = 0; i < dirEntries.length; ++i) {
                this.delete(channel, new Path(absolute, dirEntries[i].getPath()), recursive);
            }
        }
        try {
            channel.rmdir(pathName);
        }
        catch (SftpException e) {
            status = false;
        }
        return status;
    }

    private FileStatus[] listStatus(ChannelSftp client, Path file) throws IOException {
        Vector sftpFiles;
        Path workDir;
        try {
            workDir = new Path(client.pwd());
        }
        catch (SftpException e) {
            throw new IOException(e);
        }
        Path absolute = this.makeAbsolute(workDir, file);
        FileStatus fileStat = this.getFileStatus(client, absolute);
        if (!fileStat.isDirectory()) {
            return new FileStatus[]{fileStat};
        }
        try {
            sftpFiles = client.ls(absolute.toUri().getPath());
        }
        catch (SftpException e) {
            throw new IOException(e);
        }
        ArrayList<FileStatus> fileStats = new ArrayList<FileStatus>();
        for (int i = 0; i < sftpFiles.size(); ++i) {
            ChannelSftp.LsEntry entry = (ChannelSftp.LsEntry)sftpFiles.get(i);
            String fname = entry.getFilename();
            if (".".equalsIgnoreCase(fname) || "..".equalsIgnoreCase(fname)) continue;
            fileStats.add(this.getFileStatus(client, entry, absolute));
        }
        return fileStats.toArray(new FileStatus[fileStats.size()]);
    }

    private boolean rename(ChannelSftp channel, Path src, Path dst) throws IOException {
        Path workDir;
        try {
            workDir = new Path(channel.pwd());
        }
        catch (SftpException e) {
            throw new IOException(e);
        }
        Path absoluteSrc = this.makeAbsolute(workDir, src);
        Path absoluteDst = this.makeAbsolute(workDir, dst);
        if (!this.exists(channel, absoluteSrc)) {
            throw new IOException(String.format(E_SPATH_NOTEXIST, src));
        }
        if (this.exists(channel, absoluteDst)) {
            throw new IOException(String.format(E_DPATH_EXIST, dst));
        }
        boolean renamed = true;
        try {
            String previousCwd = channel.pwd();
            channel.cd("/");
            channel.rename(src.toUri().getPath(), dst.toUri().getPath());
            channel.cd(previousCwd);
        }
        catch (SftpException e) {
            renamed = false;
        }
        return renamed;
    }

    @Override
    public void initialize(URI uriInfo, Configuration conf) throws IOException {
        super.initialize(uriInfo, conf);
        this.setConfigurationFromURI(uriInfo, conf);
        this.setConf(conf);
        this.uri = uriInfo;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        Path workDir;
        final ChannelSftp channel = this.connect();
        try {
            workDir = new Path(channel.pwd());
        }
        catch (SftpException e) {
            throw new IOException(e);
        }
        Path absolute = this.makeAbsolute(workDir, f);
        FileStatus fileStat = this.getFileStatus(channel, absolute);
        if (fileStat.isDirectory()) {
            this.disconnect(channel);
            throw new IOException(String.format(E_PATH_DIR, f));
        }
        try {
            absolute = new Path("/", channel.realpath(absolute.toUri().getPath()));
        }
        catch (SftpException e) {
            throw new IOException(e);
        }
        return new FSDataInputStream(new SFTPInputStream(channel, absolute, this.statistics)){

            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    SFTPFileSystem.this.disconnect(channel);
                }
            }
        };
    }

    @Override
    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        OutputStream os;
        Path parent;
        Path workDir;
        final ChannelSftp client = this.connect();
        try {
            workDir = new Path(client.pwd());
        }
        catch (SftpException e) {
            throw new IOException(e);
        }
        Path absolute = this.makeAbsolute(workDir, f);
        if (this.exists(client, f)) {
            if (overwrite) {
                this.delete(client, f, false);
            } else {
                this.disconnect(client);
                throw new IOException(String.format(E_FILE_EXIST, f));
            }
        }
        if ((parent = absolute.getParent()) == null || !this.mkdirs(client, parent, FsPermission.getDefault())) {
            parent = parent == null ? new Path("/") : parent;
            this.disconnect(client);
            throw new IOException(String.format(E_CREATE_DIR, parent));
        }
        try {
            String previousCwd = client.pwd();
            client.cd(parent.toUri().getPath());
            os = client.put(f.getName());
            client.cd(previousCwd);
        }
        catch (SftpException e) {
            throw new IOException(e);
        }
        FSDataOutputStream fos = new FSDataOutputStream(os, this.statistics){

            @Override
            public void close() throws IOException {
                super.close();
                SFTPFileSystem.this.disconnect(client);
            }
        };
        return fos;
    }

    @Override
    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        throw new UnsupportedOperationException("Append is not supported by SFTPFileSystem");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        ChannelSftp channel = this.connect();
        try {
            boolean success;
            boolean bl = success = this.rename(channel, src, dst);
            return bl;
        }
        finally {
            this.disconnect(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(Path f, boolean recursive) throws IOException {
        ChannelSftp channel = this.connect();
        try {
            boolean success;
            boolean bl = success = this.delete(channel, f, recursive);
            return bl;
        }
        finally {
            this.disconnect(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileStatus[] listStatus(Path f) throws IOException {
        ChannelSftp client = this.connect();
        try {
            FileStatus[] stats;
            FileStatus[] fileStatusArray = stats = this.listStatus(client, f);
            return fileStatusArray;
        }
        finally {
            this.disconnect(client);
        }
    }

    @Override
    public void setWorkingDirectory(Path newDir) {
    }

    @Override
    public Path getWorkingDirectory() {
        return this.getHomeDirectory();
    }

    private Path getWorkingDirectory(ChannelSftp client) {
        return this.getHomeDirectory(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Path getHomeDirectory() {
        ChannelSftp channel = null;
        try {
            Path homeDir;
            channel = this.connect();
            Path path = homeDir = new Path(channel.pwd());
            return path;
        }
        catch (Exception ioe) {
            Path path = null;
            return path;
        }
        finally {
            try {
                this.disconnect(channel);
            }
            catch (IOException ioe) {
                return null;
            }
        }
    }

    private Path getHomeDirectory(ChannelSftp channel) {
        try {
            return new Path(channel.pwd());
        }
        catch (Exception ioe) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        ChannelSftp client = this.connect();
        try {
            boolean success;
            boolean bl = success = this.mkdirs(client, f, permission);
            return bl;
        }
        finally {
            this.disconnect(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileStatus getFileStatus(Path f) throws IOException {
        ChannelSftp channel = this.connect();
        try {
            FileStatus status;
            FileStatus fileStatus = status = this.getFileStatus(channel, f);
            return fileStatus;
        }
        finally {
            this.disconnect(channel);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed.getAndSet(true)) {
            return;
        }
        try {
            super.close();
        }
        finally {
            if (this.connectionPool != null) {
                this.connectionPool.shutdown();
            }
        }
    }

    private void checkNotClosed() throws IOException {
        if (this.closed.get()) {
            throw new IOException(this.uri + ": " + E_FS_CLOSED);
        }
    }

    @VisibleForTesting
    SFTPConnectionPool getConnectionPool() {
        return this.connectionPool;
    }
}

