/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.service.application;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.gateway.api.results.ResultSet;
import org.apache.flink.table.gateway.api.utils.SqlGatewayException;
import org.apache.flink.table.gateway.service.result.ResultFetcher;
import org.apache.flink.util.CloseableIterator;

public class Printer {
    @VisibleForTesting
    public static final String STATEMENT_BEGIN = "Flink SQL> ";
    @VisibleForTesting
    public static final String LINE_BEGIN = "> ";
    @VisibleForTesting
    final PrintWriter writer;

    public Printer() {
        this(System.out);
    }

    public Printer(OutputStream output) {
        this.writer = new PrintWriter(output, true);
    }

    public void print(String statement) {
        try (BufferedReader reader = new BufferedReader(new StringReader(statement));){
            String line;
            this.writer.print(STATEMENT_BEGIN);
            this.writer.println(reader.readLine());
            while ((line = reader.readLine()) != null) {
                this.writer.print(LINE_BEGIN);
                this.writer.println(line);
            }
        }
        catch (IOException e) {
            throw new SqlGatewayException("Failed to read the line.", e);
        }
    }

    public void print(ResultFetcher result) {
        result.getPrintStyle().print((Iterator)((Object)new RowDataIterator(result)), this.writer);
    }

    public void print(Throwable t) {
        t.printStackTrace(this.writer);
    }

    @VisibleForTesting
    public static class RowDataIterator
    implements CloseableIterator<RowData> {
        private final ResultFetcher fetcher;
        private Iterator<RowData> current;
        @Nullable
        private Long nextToken;

        public RowDataIterator(ResultFetcher fetcher) {
            this.fetcher = fetcher;
            this.nextToken = 0L;
        }

        public boolean hasNext() {
            while (this.current == null || !this.current.hasNext()) {
                if (this.nextToken == null) {
                    return false;
                }
                ResultSet resultSet = this.fetcher.fetchResults(this.nextToken, Integer.MAX_VALUE);
                this.current = resultSet.getData().iterator();
                this.nextToken = resultSet.getNextToken();
                if (resultSet.getResultType() == ResultSet.ResultType.EOS) {
                    return this.current.hasNext();
                }
                if (resultSet.getResultType() != ResultSet.ResultType.NOT_READY) continue;
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    throw new SqlGatewayException("Failed to wait job finishes.", e);
                }
            }
            return true;
        }

        public RowData next() {
            return this.current.next();
        }

        public void close() {
            this.fetcher.close();
        }
    }
}

