/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.deduplicate;

import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.deduplicate.SyncStateDeduplicateFunctionBase;
import org.apache.flink.table.runtime.operators.deduplicate.utils.RowTimeDeduplicateFunctionHelper;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.util.Collector;

public class RowTimeDeduplicateFunction
extends SyncStateDeduplicateFunctionBase<RowData, RowData, RowData, RowData> {
    private static final long serialVersionUID = 1L;
    private final boolean generateUpdateBefore;
    private final boolean generateInsert;
    private final int rowtimeIndex;
    private final boolean keepLastRow;
    private transient SyncStateRowTimeDeduplicateFunctionHelper helper;

    public RowTimeDeduplicateFunction(InternalTypeInfo<RowData> typeInfo, long minRetentionTime, int rowtimeIndex, boolean generateUpdateBefore, boolean generateInsert, boolean keepLastRow) {
        super(typeInfo, null, minRetentionTime);
        this.generateUpdateBefore = generateUpdateBefore;
        this.generateInsert = generateInsert;
        this.rowtimeIndex = rowtimeIndex;
        this.keepLastRow = keepLastRow;
    }

    @Override
    public void open(OpenContext openContext) throws Exception {
        super.open(openContext);
        this.helper = new SyncStateRowTimeDeduplicateFunctionHelper();
    }

    public void processElement(RowData input, KeyedProcessFunction.Context ctx, Collector<RowData> out) throws Exception {
        RowData prevRow = (RowData)this.state.value();
        this.helper.deduplicateOnRowTime(input, prevRow, out);
    }

    private class SyncStateRowTimeDeduplicateFunctionHelper
    extends RowTimeDeduplicateFunctionHelper {
        public SyncStateRowTimeDeduplicateFunctionHelper() {
            super(RowTimeDeduplicateFunction.this.generateUpdateBefore, RowTimeDeduplicateFunction.this.generateInsert, RowTimeDeduplicateFunction.this.rowtimeIndex, RowTimeDeduplicateFunction.this.keepLastRow);
        }

        @Override
        protected void updateState(RowData currentRow) throws Exception {
            RowTimeDeduplicateFunction.this.state.update((Object)currentRow);
        }
    }
}

