/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.window;

import java.time.ZoneId;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.window.WindowJoinOperator;
import org.apache.flink.table.runtime.operators.join.window.asyncprocessing.AsyncStateWindowJoinOperator;
import org.apache.flink.util.Preconditions;

public class WindowJoinOperatorBuilder {
    private TypeSerializer<RowData> leftSerializer;
    private TypeSerializer<RowData> rightSerializer;
    private GeneratedJoinCondition generatedJoinCondition;
    private int leftWindowEndIndex = -1;
    private int rightWindowEndIndex = -1;
    private boolean[] filterNullKeys;
    private FlinkJoinType joinType;
    private ZoneId shiftTimeZone = ZoneId.of("UTC");
    private boolean enableAsyncState = false;

    public static WindowJoinOperatorBuilder builder() {
        return new WindowJoinOperatorBuilder();
    }

    public WindowJoinOperatorBuilder leftSerializer(TypeSerializer<RowData> leftSerializer) {
        this.leftSerializer = leftSerializer;
        return this;
    }

    public WindowJoinOperatorBuilder rightSerializer(TypeSerializer<RowData> rightSerializer) {
        this.rightSerializer = rightSerializer;
        return this;
    }

    public WindowJoinOperatorBuilder generatedJoinCondition(GeneratedJoinCondition generatedJoinCondition) {
        this.generatedJoinCondition = generatedJoinCondition;
        return this;
    }

    public WindowJoinOperatorBuilder filterNullKeys(boolean[] filterNullKeys) {
        this.filterNullKeys = filterNullKeys;
        return this;
    }

    public WindowJoinOperatorBuilder joinType(FlinkJoinType joinType) {
        this.joinType = joinType;
        return this;
    }

    public WindowJoinOperatorBuilder leftWindowEndIndex(int leftWindowEndIndex) {
        this.leftWindowEndIndex = leftWindowEndIndex;
        return this;
    }

    public WindowJoinOperatorBuilder rightWindowEndIndex(int rightWindowEndIndex) {
        this.rightWindowEndIndex = rightWindowEndIndex;
        return this;
    }

    public WindowJoinOperatorBuilder withShiftTimezone(ZoneId shiftTimeZone) {
        this.shiftTimeZone = shiftTimeZone;
        return this;
    }

    public WindowJoinOperatorBuilder enableAsyncState() {
        this.enableAsyncState = true;
        return this;
    }

    public TwoInputStreamOperator<RowData, RowData, RowData> build() {
        Preconditions.checkNotNull(this.leftSerializer);
        Preconditions.checkNotNull(this.rightSerializer);
        Preconditions.checkNotNull((Object)this.generatedJoinCondition);
        Preconditions.checkNotNull((Object)this.filterNullKeys);
        Preconditions.checkNotNull((Object)((Object)this.joinType));
        Preconditions.checkArgument((this.leftWindowEndIndex >= 0 ? 1 : 0) != 0, (Object)String.format("Illegal window end index %s, it should not be negative!", this.leftWindowEndIndex));
        Preconditions.checkArgument((this.rightWindowEndIndex >= 0 ? 1 : 0) != 0, (Object)String.format("Illegal window end index %s, it should not be negative!", this.rightWindowEndIndex));
        if (this.enableAsyncState) {
            return new AsyncStateWindowJoinOperator(this.leftSerializer, this.rightSerializer, this.generatedJoinCondition, this.leftWindowEndIndex, this.rightWindowEndIndex, this.filterNullKeys, this.shiftTimeZone, this.joinType);
        }
        return new WindowJoinOperator(this.leftSerializer, this.rightSerializer, this.generatedJoinCondition, this.leftWindowEndIndex, this.rightWindowEndIndex, this.filterNullKeys, this.shiftTimeZone, this.joinType);
    }
}

