/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.model;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.model.JsonLattice;
import org.apache.calcite.model.ModelHandler;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;

public class JsonMaterialization {
    public final @Nullable String view;
    public final @Nullable String table;
    public final Object sql;
    public final @Nullable List<String> viewSchemaPath;

    @JsonCreator
    public JsonMaterialization(@JsonProperty(value="view") @Nullable String view, @JsonProperty(value="table") @Nullable String table, @JsonProperty(value="sql", required=true) Object sql, @JsonProperty(value="viewSchemaPath") @Nullable List<String> viewSchemaPath) {
        this.view = view;
        this.table = table;
        this.sql = Objects.requireNonNull(sql, "sql");
        this.viewSchemaPath = viewSchemaPath;
    }

    public void accept(ModelHandler handler) {
        handler.visit(this);
    }

    public String toString() {
        return "JsonMaterialization(table=" + this.table + ", view=" + this.view + ")";
    }

    public String getSql() {
        return JsonLattice.toString(this.sql);
    }
}

