/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters;

import java.util.Optional;
import org.apache.flink.sql.parser.dql.SqlShowCreateModel;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ContextResolvedModel;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.ShowCreateModelOperation;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;

public class SqlShowCreateModelConverter
implements SqlNodeConverter<SqlShowCreateModel> {
    @Override
    public Operation convertSqlNode(SqlShowCreateModel showCreateModel, SqlNodeConverter.ConvertContext context) {
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])showCreateModel.getFullModelName());
        ObjectIdentifier identifier = context.getCatalogManager().qualifyIdentifier(unresolvedIdentifier);
        Optional model = context.getCatalogManager().getModel(identifier);
        if (model.isEmpty()) {
            throw new ValidationException(String.format("Could not execute SHOW CREATE MODEL. Model with identifier %s does not exist.", identifier.asSerializableString()));
        }
        return new ShowCreateModelOperation(identifier, ((ContextResolvedModel)model.get()).getResolvedModel(), ((ContextResolvedModel)model.get()).isTemporary());
    }
}

