/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.batch;

import java.util.Collections;
import java.util.List;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.logical.TimeAttributeWindowingStrategy;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.common.CommonExecWindowTableFunction;
import org.apache.flink.table.types.logical.RowType;

@ExecNodeMetadata(name="batch-exec-window-table-function", version=1, producedTransformations={"window"}, minPlanVersion=FlinkVersion.v2_0, minStateVersion=FlinkVersion.v2_0)
public class BatchExecWindowTableFunction
extends CommonExecWindowTableFunction
implements BatchExecNode<RowData> {
    public BatchExecWindowTableFunction(ReadableConfig tableConfig, TimeAttributeWindowingStrategy windowingStrategy, InputProperty inputProperty, RowType outputType, String description) {
        super(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(BatchExecWindowTableFunction.class), ExecNodeContext.newPersistedConfig(BatchExecWindowTableFunction.class, tableConfig), windowingStrategy, Collections.singletonList(inputProperty), outputType, description);
    }

    @JsonCreator
    public BatchExecWindowTableFunction(@JsonProperty(value="id") int id, @JsonProperty(value="type") ExecNodeContext context, @JsonProperty(value="configuration") ReadableConfig persistedConfig, @JsonProperty(value="windowing") TimeAttributeWindowingStrategy windowingStrategy, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") RowType outputType, @JsonProperty(value="description") String description) {
        super(id, context, persistedConfig, windowingStrategy, inputProperties, outputType, description);
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        if (this.windowingStrategy.isProctime()) {
            throw new TableException("Processing time Window TableFunction is not supported yet.");
        }
        return super.translateToPlanInternal(planner, config);
    }

    @Override
    protected Transformation<RowData> translateWithUnalignedWindow(PlannerBase planner, ExecNodeConfig config, RowType inputRowType, Transformation<RowData> inputTransform) {
        throw new TableException("Unaligned windows like session are not supported in batch mode yet.");
    }
}

