/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.math.BigDecimal;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.plan.rules.logical.LogicalWindowAggregateRuleBase;
import org.apache.flink.table.planner.plan.rules.logical.StreamLogicalWindowAggregateRule$;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.types.logical.LogicalType;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u001d4AAC\u0006\u00019!)\u0011\u0005\u0001C\u0001E!1A\u0005\u0001C!'\u0015Ba\u0001\u000f\u0001\u0005BMI\u0004\"\u0002+\u0001\t\u0003)v!B/\f\u0011\u0003qf!\u0002\u0006\f\u0011\u0003y\u0006\"B\u0011\u0007\t\u0003\u0019\u0007b\u00023\u0007\u0005\u0004%\t!\u001a\u0005\u0007M\u001a\u0001\u000b\u0011B\u0012\u0003AM#(/Z1n\u0019><\u0017nY1m/&tGm\\<BO\u001e\u0014XmZ1uKJ+H.\u001a\u0006\u0003\u00195\tq\u0001\\8hS\u000e\fGN\u0003\u0002\u000f\u001f\u0005)!/\u001e7fg*\u0011\u0001#E\u0001\u0005a2\fgN\u0003\u0002\u0013'\u00059\u0001\u000f\\1o]\u0016\u0014(B\u0001\u000b\u0016\u0003\u0015!\u0018M\u00197f\u0015\t1r#A\u0003gY&t7N\u0003\u0002\u00193\u00051\u0011\r]1dQ\u0016T\u0011AG\u0001\u0004_J<7\u0001A\n\u0003\u0001u\u0001\"AH\u0010\u000e\u0003-I!\u0001I\u0006\u0003=1{w-[2bY^Kg\u000eZ8x\u0003\u001e<'/Z4bi\u0016\u0014V\u000f\\3CCN,\u0017A\u0002\u001fj]&$h\bF\u0001$!\tq\u0002!A\u000fhKRLe.Q4he\u0016<\u0017\r^3He>,\b/\u0012=qe\u0016\u001c8/[8o)\r1cf\r\t\u0003O1j\u0011\u0001\u000b\u0006\u0003S)\n1A]3y\u0015\tYs#A\u0004dC2\u001c\u0017\u000e^3\n\u00055B#a\u0002*fq:{G-\u001a\u0005\u0006_\t\u0001\r\u0001M\u0001\u000be\u0016D()^5mI\u0016\u0014\bCA\u00142\u0013\t\u0011\u0004F\u0001\u0006SKb\u0014U/\u001b7eKJDQ\u0001\u000e\u0002A\u0002U\n\u0001c^5oI><X\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005\u001d2\u0014BA\u001c)\u0005\u001d\u0011V\r_\"bY2\fQcZ3u)&lWMR5fY\u0012\u0014VMZ3sK:\u001cW\r\u0006\u0003;\u0001\nS\u0005CA\u001e?\u001b\u0005a$BA\u001f\u0014\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\u0005}b$\u0001\u0007$jK2$'+\u001a4fe\u0016t7-Z#yaJ,7o]5p]\")\u0011i\u0001a\u0001M\u00059q\u000e]3sC:$\u0007\"B\"\u0004\u0001\u0004!\u0015A\u0005;j[\u0016\fE\u000f\u001e:jEV$X-\u00138eKb\u0004\"!\u0012%\u000e\u0003\u0019S\u0011aR\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0013\u001a\u00131!\u00138u\u0011\u0015Y5\u00011\u0001M\u0003\u001d\u0011xn\u001e+za\u0016\u0004\"!\u0014*\u000e\u00039S!a\u0014)\u0002\tQL\b/\u001a\u0006\u0003#*\n1A]3m\u0013\t\u0019fJA\u0006SK2$\u0015\r^1UsB,\u0017\u0001E4fi>\u0003XM]1oI\u0006\u001bHj\u001c8h)\r1\u0016l\u0017\t\u0003\u000b^K!\u0001\u0017$\u0003\t1{gn\u001a\u0005\u00065\u0012\u0001\r!N\u0001\u0005G\u0006dG\u000eC\u0003]\t\u0001\u0007A)A\u0002jIb\f\u0001e\u0015;sK\u0006lGj\\4jG\u0006dw+\u001b8e_^\fum\u001a:fO\u0006$XMU;mKB\u0011aDB\n\u0003\r\u0001\u0004\"!R1\n\u0005\t4%AB!osJ+g\rF\u0001_\u0003!Iej\u0015+B\u001d\u000e+U#A\u0012\u0002\u0013%s5\u000bV!O\u0007\u0016\u0003\u0003")
public class StreamLogicalWindowAggregateRule
extends LogicalWindowAggregateRuleBase {
    public static StreamLogicalWindowAggregateRule INSTANCE() {
        return StreamLogicalWindowAggregateRule$.MODULE$.INSTANCE();
    }

    @Override
    public RexNode getInAggregateGroupExpression(RexBuilder rexBuilder, RexCall windowExpression) {
        RexNode timeAttribute = (RexNode)windowExpression.operands.get(0);
        if (!FlinkTypeFactory$.MODULE$.isTimeIndicatorType(timeAttribute.getType())) {
            throw new TableException(new StringBuilder(84).append("Window aggregate can only be defined over a ").append("time attribute column, but ").append(timeAttribute.getType()).append(" encountered.").toString());
        }
        return timeAttribute;
    }

    @Override
    public FieldReferenceExpression getTimeFieldReference(RexNode operand, int timeAttributeIndex, RelDataType rowType) {
        if (!FlinkTypeFactory$.MODULE$.isTimeIndicatorType(operand.getType())) {
            throw new ValidationException("Window can only be defined over a time attribute column.");
        }
        String fieldName = rowType.getFieldList().get(timeAttributeIndex).getName();
        RelDataType fieldType = rowType.getFieldList().get(timeAttributeIndex).getType();
        return new FieldReferenceExpression(fieldName, LogicalTypeDataTypeConverter.fromLogicalTypeToDataType((LogicalType)FlinkTypeFactory$.MODULE$.toLogicalType(fieldType)), 0, timeAttributeIndex);
    }

    @Override
    public long getOperandAsLong(RexCall call, int idx) {
        boolean bl = false;
        RexLiteral rexLiteral = null;
        RexNode rexNode = call.getOperands().get(idx);
        if (rexNode instanceof RexLiteral) {
            bl = true;
            rexLiteral = (RexLiteral)rexNode;
            SqlTypeFamily sqlTypeFamily = rexLiteral.getTypeName().getFamily();
            SqlTypeFamily sqlTypeFamily2 = SqlTypeFamily.INTERVAL_DAY_TIME;
            if (!(sqlTypeFamily != null ? !sqlTypeFamily.equals(sqlTypeFamily2) : sqlTypeFamily2 != null)) {
                return ((BigDecimal)rexLiteral.getValue()).longValue();
            }
        }
        if (bl) {
            throw new TableException("Window aggregate only support SECOND, MINUTE, HOUR, DAY as the time unit. MONTH and YEAR time unit are not supported yet.");
        }
        throw new TableException("Only constant window descriptors are supported.");
    }

    public StreamLogicalWindowAggregateRule() {
        super("StreamLogicalWindowAggregateRule");
    }
}

