/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table.stream.compact;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.Function;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.connector.file.table.BinPacking;
import org.apache.flink.connector.file.table.stream.TaskTracker;
import org.apache.flink.connector.file.table.stream.compact.CompactMessages;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.runtime.state.StateSnapshotContext;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.function.SupplierWithException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class CompactCoordinator
extends AbstractStreamOperator<CompactMessages.CoordinatorOutput>
implements OneInputStreamOperator<CompactMessages.CoordinatorInput, CompactMessages.CoordinatorOutput> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(CompactCoordinator.class);
    private final SupplierWithException<FileSystem, IOException> fsFactory;
    private final long targetFileSize;
    private transient FileSystem fileSystem;
    private transient ListState<Map<Long, Map<String, List<Path>>>> inputFilesState;
    private transient TreeMap<Long, Map<String, List<Path>>> inputFiles;
    private transient Map<String, List<Path>> currentInputFiles;
    private transient TaskTracker inputTaskTracker;

    public CompactCoordinator(SupplierWithException<FileSystem, IOException> fsFactory, long targetFileSize) {
        this.fsFactory = fsFactory;
        this.targetFileSize = targetFileSize;
    }

    public void initializeState(StateInitializationContext context) throws Exception {
        super.initializeState(context);
        this.fileSystem = (FileSystem)this.fsFactory.get();
        ListStateDescriptor filesDescriptor = new ListStateDescriptor("files-state", (TypeSerializer)new MapSerializer((TypeSerializer)LongSerializer.INSTANCE, (TypeSerializer)new MapSerializer((TypeSerializer)StringSerializer.INSTANCE, (TypeSerializer)new ListSerializer((TypeSerializer)new KryoSerializer(Path.class, this.getExecutionConfig().getSerializerConfig())))));
        this.inputFilesState = context.getOperatorStateStore().getListState(filesDescriptor);
        this.inputFiles = new TreeMap();
        this.currentInputFiles = new HashMap<String, List<Path>>();
        if (context.isRestored()) {
            this.inputFiles.putAll((Map)((Iterable)this.inputFilesState.get()).iterator().next());
        }
    }

    public void processElement(StreamRecord<CompactMessages.CoordinatorInput> element) throws Exception {
        CompactMessages.CoordinatorInput value = (CompactMessages.CoordinatorInput)element.getValue();
        if (value instanceof CompactMessages.InputFile) {
            CompactMessages.InputFile file = (CompactMessages.InputFile)value;
            this.currentInputFiles.computeIfAbsent(file.getPartition(), k -> new ArrayList()).add(file.getFile());
        } else if (value instanceof CompactMessages.EndCheckpoint) {
            boolean triggerCommit;
            CompactMessages.EndCheckpoint endCheckpoint = (CompactMessages.EndCheckpoint)value;
            if (this.inputTaskTracker == null) {
                this.inputTaskTracker = new TaskTracker(endCheckpoint.getNumberOfTasks());
            }
            if (triggerCommit = this.inputTaskTracker.add(endCheckpoint.getCheckpointId(), endCheckpoint.getTaskId())) {
                this.commitUpToCheckpoint(endCheckpoint.getCheckpointId());
            }
        } else {
            throw new UnsupportedOperationException("Unsupported input message: " + String.valueOf(value));
        }
    }

    private void commitUpToCheckpoint(long checkpointId) {
        NavigableMap<Long, Map<String, List<Path>>> headMap = this.inputFiles.headMap(checkpointId, true);
        for (Map.Entry entry : headMap.entrySet()) {
            this.coordinate((Long)entry.getKey(), (Map)entry.getValue());
        }
        if (checkpointId == Long.MAX_VALUE) {
            this.coordinate(checkpointId, this.currentInputFiles);
            this.currentInputFiles.clear();
        }
        headMap.clear();
    }

    private void coordinate(long checkpointId, Map<String, List<Path>> partFiles) {
        Function<Path, Long> sizeFunc = path -> {
            try {
                return this.fileSystem.getFileStatus(path).getLen();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
        HashMap compactUnits = new HashMap();
        partFiles.forEach((p, files) -> {
            files.sort(Comparator.comparing(Path::getPath));
            compactUnits.put(p, BinPacking.pack(files, sizeFunc, this.targetFileSize));
        });
        int unitId = 0;
        for (Map.Entry unitsEntry : compactUnits.entrySet()) {
            String partition = (String)unitsEntry.getKey();
            for (List unit : (List)unitsEntry.getValue()) {
                this.output.collect((Object)new StreamRecord((Object)new CompactMessages.CompactionUnit(unitId, partition, unit)));
                ++unitId;
            }
        }
        LOG.debug("Coordinate checkpoint-{}, compaction units are: {}", (Object)checkpointId, compactUnits);
        this.output.collect((Object)new StreamRecord((Object)new CompactMessages.EndCompaction(checkpointId)));
    }

    public void snapshotState(StateSnapshotContext context) throws Exception {
        super.snapshotState(context);
        this.inputFiles.put(context.getCheckpointId(), new HashMap<String, List<Path>>(this.currentInputFiles));
        this.inputFilesState.update(Collections.singletonList(this.inputFiles));
        this.currentInputFiles.clear();
    }
}

