/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.geode.cache.lucene.LuceneIndexFactory;
import org.apache.geode.cache.lucene.LuceneSerializer;
import org.apache.geode.cache.lucene.internal.LuceneServiceImpl;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;

public class LuceneIndexFactoryImpl
implements LuceneIndexFactory {
    private final LuceneServiceImpl service;
    private final Map<String, Analyzer> fields = new LinkedHashMap<String, Analyzer>();
    private LuceneSerializer serializer;

    public LuceneIndexFactoryImpl(LuceneServiceImpl luceneService) {
        this.service = luceneService;
    }

    @Override
    public LuceneIndexFactoryImpl addField(String name) {
        return this.addField(name, new StandardAnalyzer());
    }

    @Override
    public LuceneIndexFactoryImpl setFields(String ... fields) {
        this.fields.clear();
        for (String field : fields) {
            this.addField(field);
        }
        return this;
    }

    @Override
    public LuceneIndexFactoryImpl addField(String name, Analyzer analyzer) {
        this.fields.put(name, analyzer);
        return this;
    }

    @Override
    public LuceneIndexFactoryImpl setFields(Map<String, Analyzer> fieldMap) {
        this.fields.clear();
        this.fields.putAll(fieldMap);
        return this;
    }

    @Override
    public void create(String indexName, String regionPath) {
        this.create(indexName, regionPath, false);
    }

    public void create(String indexName, String regionPath, boolean allowOnExistingRegion) {
        this.service.createIndex(indexName, regionPath, this.fields, this.serializer, allowOnExistingRegion);
    }

    @Override
    public LuceneIndexFactoryImpl setLuceneSerializer(LuceneSerializer luceneSerializer) {
        this.serializer = luceneSerializer;
        return this;
    }
}

