/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.core;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import jline.console.ConsoleReader;
import org.fusesource.jansi.Ansi;
import org.springframework.shell.core.ShellPromptAccessor;
import org.springframework.shell.support.util.IOUtils;
import org.springframework.shell.support.util.OsUtils;
import org.springframework.util.Assert;

public class JLineLogHandler
extends Handler {
    private ConsoleReader reader;
    private ShellPromptAccessor shellPromptAccessor;
    private static ThreadLocal<Boolean> redrawProhibit = new ThreadLocal();
    private static String lastMessage;
    private static boolean includeThreadName;
    private boolean ansiSupported;
    private String userInterfaceThreadName;
    private static boolean suppressDuplicateMessages;

    public JLineLogHandler(ConsoleReader reader, ShellPromptAccessor shellPromptAccessor) {
        Assert.notNull((Object)reader, (String)"Console reader required");
        Assert.notNull((Object)shellPromptAccessor, (String)"Shell prompt accessor required");
        this.reader = reader;
        this.shellPromptAccessor = shellPromptAccessor;
        this.userInterfaceThreadName = Thread.currentThread().getName();
        this.ansiSupported = reader.getTerminal().isAnsiSupported();
        this.setFormatter(new Formatter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public String format(LogRecord record) {
                StringBuffer sb = new StringBuffer();
                if (record.getMessage() != null) {
                    sb.append(record.getMessage()).append(OsUtils.LINE_SEPARATOR);
                }
                if (record.getThrown() != null) {
                    PrintWriter pw = null;
                    try {
                        StringWriter sw = new StringWriter();
                        pw = new PrintWriter(sw);
                        record.getThrown().printStackTrace(pw);
                        sb.append(sw.toString());
                    }
                    catch (Exception ex) {
                        IOUtils.closeQuietly(pw);
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(pw);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly(pw);
                }
                return sb.toString();
            }
        });
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }

    public static void prohibitRedraw() {
        redrawProhibit.set(true);
    }

    public static void cancelRedrawProhibition() {
        redrawProhibit.remove();
    }

    public static void setIncludeThreadName(boolean include) {
        includeThreadName = include;
    }

    public static void resetMessageTracking() {
        lastMessage = null;
    }

    public static boolean isSuppressDuplicateMessages() {
        return suppressDuplicateMessages;
    }

    public static void setSuppressDuplicateMessages(boolean suppressDuplicateMessages) {
        JLineLogHandler.suppressDuplicateMessages = suppressDuplicateMessages;
    }

    @Override
    public void publish(LogRecord record) {
        try {
            String toDisplay = this.toDisplay(record);
            if (toDisplay.equals(lastMessage) && suppressDuplicateMessages) {
                return;
            }
            lastMessage = toDisplay;
            StringBuilder buffer = this.reader.getCursorBuffer().copy().buffer;
            int cursor = this.reader.getCursorBuffer().cursor;
            if (this.reader.getCursorBuffer().length() > 0) {
                this.reader.println();
                this.reader.getCursorBuffer().clear();
            }
            this.reader.setPrompt("");
            this.reader.redrawLine();
            this.reader.setPrompt(this.shellPromptAccessor.getShellPrompt());
            this.reader.getCursorBuffer().write((CharSequence)buffer.toString());
            this.reader.getCursorBuffer().cursor = cursor;
            this.reader.print((CharSequence)toDisplay);
            Boolean prohibitingRedraw = redrawProhibit.get();
            if (prohibitingRedraw == null) {
                this.reader.redrawLine();
            }
            this.reader.flush();
        }
        catch (Exception e) {
            this.reportError("Could not publish log message", e, Level.SEVERE.intValue());
        }
    }

    private String toDisplay(LogRecord event) {
        String eventString;
        String threadName;
        StringBuilder sb = new StringBuilder();
        if (includeThreadName && !this.userInterfaceThreadName.equals(Thread.currentThread().getName()) && !"".equals(Thread.currentThread().getName())) {
            threadName = "[" + Thread.currentThread().getName() + "]";
            StringBuilder lineSeparatorAndIndentingString = new StringBuilder();
            for (int i = 0; i <= threadName.length(); ++i) {
                lineSeparatorAndIndentingString.append(" ");
            }
            eventString = " " + this.getFormatter().format(event).replace(OsUtils.LINE_SEPARATOR, OsUtils.LINE_SEPARATOR + lineSeparatorAndIndentingString.toString());
            if (eventString.endsWith(lineSeparatorAndIndentingString.toString())) {
                eventString = eventString.substring(0, eventString.length() - lineSeparatorAndIndentingString.length());
            }
        } else {
            threadName = "";
            eventString = this.getFormatter().format(event);
        }
        if (this.ansiSupported) {
            Ansi ansi = Ansi.ansi((StringBuilder)sb);
            if (event.getLevel().intValue() >= Level.SEVERE.intValue()) {
                ansi.a(Ansi.Attribute.NEGATIVE_ON).a(threadName).a(Ansi.Attribute.NEGATIVE_OFF).fg(Ansi.Color.RED).a(eventString).reset();
            } else if (event.getLevel().intValue() >= Level.WARNING.intValue()) {
                ansi.a(Ansi.Attribute.NEGATIVE_ON).a(threadName).a(Ansi.Attribute.NEGATIVE_OFF).fg(Ansi.Color.MAGENTA).a(eventString).reset();
            } else if (event.getLevel().intValue() >= Level.INFO.intValue()) {
                ansi.a(Ansi.Attribute.NEGATIVE_ON).a(threadName).a(Ansi.Attribute.NEGATIVE_OFF).fg(Ansi.Color.GREEN).a(eventString).reset();
            } else {
                ansi.a(Ansi.Attribute.NEGATIVE_ON).a(threadName).a(Ansi.Attribute.NEGATIVE_OFF).a(eventString);
            }
        } else {
            sb.append(threadName).append(eventString);
        }
        return sb.toString();
    }

    static {
        includeThreadName = false;
        suppressDuplicateMessages = true;
    }
}

