/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.alerting.internal;

import java.time.Instant;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.apache.geode.alerting.internal.AlertListenerMessageFactory;
import org.apache.geode.alerting.internal.AlertMessaging;
import org.apache.geode.alerting.internal.spi.AlertLevel;
import org.apache.geode.alerting.internal.spi.AlertingAction;
import org.apache.geode.alerting.internal.spi.AlertingIOException;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.admin.remote.AlertListenerMessage;
import org.apache.geode.internal.tcp.ReenteredConnectException;
import org.apache.geode.logging.internal.executors.LoggingExecutors;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class ClusterAlertMessaging
implements AlertMessaging {
    private static final Logger LOGGER = LogService.getLogger();
    private final InternalDistributedSystem system;
    private final DistributionManager dm;
    private final AlertListenerMessageFactory alertListenerMessageFactory;
    private final ExecutorService executor;
    private final Consumer<AlertingIOException> alertingIOExceptionLogger;

    public ClusterAlertMessaging(InternalDistributedSystem system) {
        this(system, system.getDistributionManager(), new AlertListenerMessageFactory(), LoggingExecutors.newFixedThreadPool((int)1, (String)"AlertingMessaging Processor", (boolean)true), arg_0 -> ((Logger)LOGGER).warn(arg_0));
    }

    @VisibleForTesting
    ClusterAlertMessaging(InternalDistributedSystem system, DistributionManager dm, AlertListenerMessageFactory alertListenerMessageFactory, ExecutorService executor) {
        this(system, dm, alertListenerMessageFactory, executor, arg_0 -> ((Logger)LOGGER).warn(arg_0));
    }

    @VisibleForTesting
    ClusterAlertMessaging(InternalDistributedSystem system, DistributionManager dm, AlertListenerMessageFactory alertListenerMessageFactory, ExecutorService executor, Consumer<AlertingIOException> alertingIOExceptionLogger) {
        this.system = system;
        this.dm = dm;
        this.alertListenerMessageFactory = alertListenerMessageFactory;
        this.executor = executor;
        this.alertingIOExceptionLogger = alertingIOExceptionLogger;
    }

    @Override
    public void sendAlert(DistributedMember member, AlertLevel alertLevel, Instant timestamp, String threadName, long threadId, String formattedMessage, String stackTrace) {
        this.executor.submit(() -> AlertingAction.execute(() -> {
            try {
                String connectionName = this.system.getConfig().getName();
                AlertListenerMessage message = this.alertListenerMessageFactory.createAlertListenerMessage(member, alertLevel, timestamp, connectionName, threadName, threadId, formattedMessage, stackTrace);
                if (member.equals(this.system.getDistributedMember())) {
                    LOGGER.debug("Processing local alert message: {}, {}, {}, {}, {}, {}, [{}], [{}].", (Object)member, (Object)alertLevel, (Object)timestamp, (Object)connectionName, (Object)threadName, (Object)threadId, (Object)formattedMessage, (Object)stackTrace);
                    this.processAlertListenerMessage(message);
                } else {
                    LOGGER.debug("Sending remote alert message: {}, {}, {}, {}, {}, {}, [{}], [{}].", (Object)member, (Object)alertLevel, (Object)timestamp, (Object)connectionName, (Object)threadName, (Object)threadId, (Object)formattedMessage, (Object)stackTrace);
                    this.dm.putOutgoing(message);
                }
            }
            catch (ReenteredConnectException connectionName) {
            }
            catch (AlertingIOException e) {
                this.alertingIOExceptionLogger.accept(e);
            }
        }));
    }

    public void close() {
        this.executor.shutdownNow();
    }

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
    }

    @VisibleForTesting
    void processAlertListenerMessage(AlertListenerMessage message) {
        this.verifyDistributionManagerCanProcessMessage();
        message.process((ClusterDistributionManager)this.dm);
    }

    private void verifyDistributionManagerCanProcessMessage() {
        if (!(this.dm instanceof ClusterDistributionManager)) {
            throw new IllegalArgumentException("Processing of AlertListenerMessage requires ClusterDistributionManager instead of " + this.dm.getClass().getSimpleName());
        }
    }
}

