/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin;

import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.ExpirationAction;
import org.apache.geode.cache.ExpirationAttributes;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.util.CacheListenerAdapter;
import org.apache.geode.internal.admin.remote.ClientHealthStats;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegionFactory;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class ClientHealthMonitoringRegion {
    private static final Logger logger = LogService.getLogger();
    public static final String ADMIN_REGION_NAME = "__ADMIN_CLIENT_HEALTH_MONITORING__";
    static final int ADMIN_REGION_EXPIRY_INTERVAL = 20;
    @MakeNotStatic
    private static Region currentInstance;

    public static synchronized Region getInstance(InternalCache cache) {
        if (currentInstance != null && currentInstance.getCache() == cache && !cache.isClosed()) {
            return currentInstance;
        }
        if (cache == null || cache.isClosed()) {
            return null;
        }
        ClientHealthMonitoringRegion.initialize(cache);
        return currentInstance;
    }

    private static void initialize(InternalCache cache) {
        try {
            InternalRegionFactory factory = cache.createInternalRegionFactory(RegionShortcut.LOCAL);
            factory.setEntryTimeToLive(new ExpirationAttributes(20, ExpirationAction.DESTROY));
            if (logger.isDebugEnabled()) {
                logger.debug("ClientHealthMonitoringRegion, setting TTL for entry....");
            }
            factory.addCacheListener(ClientHealthMonitoringRegion.prepareCacheListener());
            factory.setValueConstraint(ClientHealthStats.class);
            factory.setStatisticsEnabled(true);
            factory.setIsUsedForMetaRegion(true).setIsUsedForPartitionedRegionAdmin(false);
            currentInstance = factory.create(ADMIN_REGION_NAME);
        }
        catch (Exception ex) {
            logger.error("Error while creating an admin region", (Throwable)ex);
        }
    }

    private static CacheListener prepareCacheListener() {
        return new CacheListenerAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() {
                Class<ClientHealthMonitoringRegion> clazz = ClientHealthMonitoringRegion.class;
                synchronized (ClientHealthMonitoringRegion.class) {
                    currentInstance = null;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        };
    }
}

