/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.statalerts;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.StatisticDescriptor;
import org.apache.geode.Statistics;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.internal.admin.StatAlert;
import org.apache.geode.internal.admin.StatAlertDefinition;
import org.apache.geode.internal.admin.statalerts.StatisticInfo;

public class MultiAttrDefinitionImpl
implements StatAlertDefinition {
    private static final long serialVersionUID = 2508805676076940969L;
    protected String _name;
    protected int _id;
    protected StatisticInfo[] statisticInfo;

    public MultiAttrDefinitionImpl() {
    }

    public MultiAttrDefinitionImpl(String name, StatisticInfo[] statInfo) {
        this.setStatisticInfo(statInfo);
        this._name = name;
        this._id = this.getName().toUpperCase().hashCode();
    }

    @Override
    public int getId() {
        return this._id;
    }

    public int hashCode() {
        return this.getId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiAttrDefinitionImpl)) {
            return false;
        }
        MultiAttrDefinitionImpl that = (MultiAttrDefinitionImpl)o;
        return this._id == that._id;
    }

    @Override
    public boolean verify(StatisticsFactory factory) {
        if (this.statisticInfo == null || this.statisticInfo.length == 0) {
            return false;
        }
        boolean result = false;
        block0: for (StatisticInfo info : this.statisticInfo) {
            if (info != null) {
                StatisticDescriptor[] temp1;
                Statistics[] temp = factory.findStatisticsByTextId(info.getStatisticsTextId());
                if (temp == null || temp.length == 0) {
                    return false;
                }
                for (StatisticDescriptor statisticDescriptor : temp1 = temp[0].getType().getStatistics()) {
                    if (!info.getStatisticName().equals(statisticDescriptor.getName())) continue;
                    result = true;
                    continue block0;
                }
                continue;
            }
            result = false;
            break;
        }
        return result;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Name:" + this.getName() + "\n");
        buffer.append("Attributes:\n");
        if (this.statisticInfo != null) {
            for (StatisticInfo info : this.statisticInfo) {
                buffer.append(info.toString() + "\n");
            }
        }
        return buffer.toString();
    }

    @Override
    public String getStringRepresentation() {
        return "StatAlertDefinition [\n" + this + "]";
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    @Override
    public void setStatisticInfo(StatisticInfo[] info) {
        if (info == null || info.length == 0) {
            throw new IllegalArgumentException("setStatisticInfo method requires non-zero length array of StatisticInfo objects.");
        }
        this.statisticInfo = info;
    }

    @Override
    public StatisticInfo[] getStatisticInfo() {
        return this.statisticInfo;
    }

    @Override
    public Number[] getValue() {
        Number[] vals = new Number[this.statisticInfo.length];
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = this.statisticInfo[i].getStatistics().get(this.statisticInfo[i].getStatisticDescriptor());
        }
        return vals;
    }

    @Override
    public Number[] getValue(Number[] vals) {
        return vals;
    }

    @Override
    public boolean evaluate(Number[] params) {
        return this.evaluate() && params != null;
    }

    @Override
    public boolean evaluate() {
        return this.statisticInfo != null && this.statisticInfo.length != 0;
    }

    @Override
    public StatAlert evaluateAndAlert(Number[] params) {
        return this.evaluate() ? this.getAlert(params) : null;
    }

    @Override
    public StatAlert evaluateAndAlert() {
        return this.evaluate() ? this.getAlert(this.getValue()) : null;
    }

    protected StatAlert getAlert(Number[] val) {
        return new StatAlert(this.getId(), val);
    }

    @Override
    public boolean hasDecorator(String decoratorID) {
        return false;
    }

    @Override
    public StatAlertDefinition getDecorator(String decoratorID) {
        return null;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeString(this._name, out);
        DataSerializer.writePrimitiveInt(this._id, out);
        DataSerializer.writeObjectArray(this.statisticInfo, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this._name = DataSerializer.readString(in);
        this._id = DataSerializer.readPrimitiveInt(in);
        this.statisticInfo = (StatisticInfo[])DataSerializer.readObjectArray(in);
    }
}

