/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.management.ObjectName;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.internal.ProxyInfo;
import org.apache.logging.log4j.Logger;

public class MBeanProxyInfoRepository {
    private static final Logger logger = LogService.getLogger();
    private final Map<ObjectName, ProxyInfo> objectNameIndex = new ConcurrentHashMap<ObjectName, ProxyInfo>();
    private final Map<DistributedMember, Set<ObjectName>> memberIndex = new ConcurrentHashMap<DistributedMember, Set<ObjectName>>();

    protected MBeanProxyInfoRepository() {
    }

    protected void addProxyToRepository(DistributedMember member, ProxyInfo proxyInfo) {
        ObjectName objectName = proxyInfo.getObjectName();
        if (logger.isTraceEnabled()) {
            logger.trace("ADDED TO PROXY REPO : {}", (Object)proxyInfo.getObjectName());
        }
        this.objectNameIndex.put(objectName, proxyInfo);
        if (this.memberIndex.get(member) != null) {
            this.memberIndex.get(member).add(proxyInfo.getObjectName());
        } else {
            CopyOnWriteArraySet<ObjectName> proxyInfoSet = new CopyOnWriteArraySet<ObjectName>();
            proxyInfoSet.add(proxyInfo.getObjectName());
            this.memberIndex.put(member, proxyInfoSet);
        }
    }

    protected <T> T findProxyByName(ObjectName objectName, Class<T> interfaceClass) {
        ProxyInfo proxyInfo;
        if (logger.isDebugEnabled()) {
            logger.debug("findProxyByName : {}", (Object)objectName);
            logger.debug("findProxyByName Existing ObjectNames  : {}", this.objectNameIndex.keySet());
        }
        if ((proxyInfo = this.objectNameIndex.get(objectName)) != null) {
            return interfaceClass.cast(proxyInfo.getProxyInstance());
        }
        return null;
    }

    protected ProxyInfo findProxyInfo(ObjectName objectName) {
        if (logger.isTraceEnabled()) {
            logger.trace("SEARCHING FOR PROXY INFO N REPO FOR MBEAN : {}", (Object)objectName);
        }
        ProxyInfo proxyInfo = this.objectNameIndex.get(objectName);
        return proxyInfo;
    }

    protected Set<ObjectName> findProxySet(DistributedMember member) {
        Set<ObjectName> proxyInfoSet;
        if (logger.isTraceEnabled()) {
            logger.trace("SEARCHING PROXIES FOR MEMBER : {}", (Object)member.getId());
        }
        if ((proxyInfoSet = this.memberIndex.get(member)) != null) {
            return Collections.unmodifiableSet(proxyInfoSet);
        }
        return Collections.emptySet();
    }

    protected void removeProxy(DistributedMember member, ObjectName objectName) {
        ProxyInfo info = this.objectNameIndex.remove(objectName);
        Set<ObjectName> proxyInfoSet = this.memberIndex.get(member);
        if (proxyInfoSet == null || proxyInfoSet.size() == 0) {
            return;
        }
        proxyInfoSet.remove(objectName);
    }
}

