/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.beans.stats;

import java.util.HashMap;
import java.util.Map;
import org.apache.geode.StatisticDescriptor;
import org.apache.geode.Statistics;
import org.apache.geode.StatisticsType;
import org.apache.geode.internal.statistics.StatisticId;
import org.apache.geode.internal.statistics.StatisticNotFoundException;
import org.apache.geode.internal.statistics.StatisticsListener;
import org.apache.geode.internal.statistics.StatisticsNotification;
import org.apache.geode.internal.statistics.ValueMonitor;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class MBeanStatsMonitor
implements StatisticsListener {
    private static final Logger logger = LogService.getLogger();
    protected ValueMonitor monitor;
    protected Map<String, Number> statsMap;
    private final String monitorName;

    public MBeanStatsMonitor(String name) {
        this(name, new ValueMonitor());
    }

    MBeanStatsMonitor(String name, ValueMonitor monitor) {
        this.monitorName = name;
        this.monitor = monitor;
        this.statsMap = new HashMap<String, Number>();
    }

    public void addStatisticsToMonitor(Statistics stats) {
        StatisticDescriptor[] descriptors;
        this.monitor.addListener(this);
        StatisticsType type = stats.getType();
        for (StatisticDescriptor d : descriptors = type.getStatistics()) {
            this.statsMap.put(d.getName(), stats.get(d));
        }
        this.monitor.addStatistics(stats);
    }

    public void removeStatisticsFromMonitor(Statistics stats) {
        this.statsMap.clear();
    }

    public void stopListener() {
        this.monitor.removeListener(this);
    }

    public Number getStatistic(String statName) {
        Number value = this.statsMap.getOrDefault(statName, 0);
        return value != null ? (Number)value : (Number)0;
    }

    @Override
    public void handleNotification(StatisticsNotification notification) {
        for (StatisticId statId : notification) {
            Number value;
            StatisticDescriptor descriptor = statId.getStatisticDescriptor();
            String name = descriptor.getName();
            try {
                value = notification.getValue(statId);
            }
            catch (StatisticNotFoundException e) {
                value = 0;
            }
            this.log(name, value);
            this.statsMap.put(name, value);
        }
    }

    protected void log(String name, Number value) {
        if (logger.isTraceEnabled()) {
            logger.trace("Monitor = {} descriptor = {} And value = {}", (Object)this.monitorName, (Object)name, (Object)value);
        }
    }
}

