/*
 * Licensed to the Apache Software Foundation (ASF) under one or more contributor license
 * agreements. See the NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The ASF licenses this file to You under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License. You may obtain a
 * copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
package benchmark.geode.data;

import java.util.Set;

import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.RegionFunctionContext;

public class FunctionWithFilter implements Function<Long> {

  public FunctionWithFilter() {}

  @Override
  public void execute(final FunctionContext<Long> context) {
    final RegionFunctionContext regionFunctionContext = (RegionFunctionContext) context;
    final Region<Long, Portfolio> region = regionFunctionContext.getDataSet();
    @SuppressWarnings("unchecked")
    final Set<Long> filterKeys = (Set<Long>) regionFunctionContext.getFilter();
    final Long key = filterKeys.iterator().next();

    context.getResultSender().lastResult(region.get(key));
  }

  @Override
  public String getId() {
    return "FunctionWithFilter";
  }

  @Override
  public boolean isHA() {
    return true;
  }
}
