/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import org.apache.hadoop.net.DNSDomainNameResolver;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestDNSDomainNameResolver {
    static DNSDomainNameResolver DNR = new DNSDomainNameResolver();

    @Test
    public void testGetHostNameByIP() throws UnknownHostException {
        InetAddress localhost = InetAddress.getLocalHost();
        Assume.assumeFalse((String)"IP lookup support required", (boolean)Objects.equals(localhost.getCanonicalHostName(), localhost.getHostAddress()));
        InetAddress unresolved = InetAddress.getByAddress(localhost.getHostAddress(), localhost.getAddress());
        Assert.assertEquals((Object)localhost.getHostAddress(), (Object)unresolved.getHostName());
        String canonicalHostName = DNR.getHostnameByIP(unresolved);
        Assert.assertNotEquals((Object)localhost.getHostAddress(), (Object)canonicalHostName);
        Assert.assertEquals((Object)localhost.getCanonicalHostName(), (Object)canonicalHostName);
    }
}

