/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.dynamometer.workloadgenerator;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.tools.dynamometer.workloadgenerator.WorkloadMapper;
import org.apache.hadoop.util.Lists;

public class CreateFileMapper
extends WorkloadMapper<NullWritable, NullWritable, NullWritable, NullWritable> {
    public static final String NUM_MAPPERS_KEY = "createfile.num-mappers";
    public static final String DURATION_MIN_KEY = "createfile.duration-min";
    public static final String FILE_PARENT_PATH_KEY = "createfile.file-parent-path";
    public static final String FILE_PARENT_PATH_DEFAULT = "/tmp/createFileMapper";
    public static final String SHOULD_DELETE_KEY = "createfile.should-delete";
    public static final boolean SHOULD_DELETE_DEFAULT = false;
    private long startTimestampMs;
    private FileSystem fs;
    private Configuration conf;
    private int taskID;
    private String fileParentPath;
    private boolean shouldDelete;
    private long endTimeStampMs;

    @Override
    public String getDescription() {
        return "This mapper creates 1-byte files for the specified duration.";
    }

    @Override
    public List<String> getConfigDescriptions() {
        return Lists.newArrayList((Object[])new String[]{"createfile.num-mappers (required): Number of mappers to launch.", "createfile.duration-min (required): Number of minutes to induce workload for.", "createfile.should-delete (default: false): If true, delete the files after creating them. This can be useful for generating constant load without increasing the number of file objects.", "createfile.file-parent-path (default: /tmp/createFileMapper): The root directory in which to create files."});
    }

    @Override
    public boolean verifyConfigurations(Configuration confToVerify) {
        return confToVerify.get(NUM_MAPPERS_KEY) != null && confToVerify.get(DURATION_MIN_KEY) != null;
    }

    public void map(NullWritable key, NullWritable value, Mapper.Context mapperContext) throws IOException, InterruptedException {
        this.taskID = mapperContext.getTaskAttemptID().getTaskID().getId();
        this.conf = mapperContext.getConfiguration();
        String namenodeURI = this.conf.get("nn_uri");
        this.startTimestampMs = this.conf.getLong("start_timestamp_ms", -1L);
        this.fileParentPath = this.conf.get(FILE_PARENT_PATH_KEY, FILE_PARENT_PATH_DEFAULT);
        this.shouldDelete = this.conf.getBoolean(SHOULD_DELETE_KEY, false);
        int durationMin = this.conf.getInt(DURATION_MIN_KEY, -1);
        if (durationMin < 0) {
            throw new IOException("Duration must be positive; got: " + durationMin);
        }
        this.endTimeStampMs = this.startTimestampMs + TimeUnit.MILLISECONDS.convert(durationMin, TimeUnit.MINUTES);
        this.fs = FileSystem.get((URI)URI.create(namenodeURI), (Configuration)this.conf);
        System.out.println("Start timestamp: " + this.startTimestampMs);
        long currentEpoch = System.currentTimeMillis();
        long delay = this.startTimestampMs - currentEpoch;
        if (delay > 0L) {
            System.out.println("Sleeping for " + delay + " ms");
            Thread.sleep(delay);
        }
        String mapperSpecifcPathPrefix = this.fileParentPath + "/mapper" + this.taskID;
        System.out.println("Mapper path prefix: " + mapperSpecifcPathPrefix);
        long numFilesCreated = 0L;
        byte[] content = new byte[]{0};
        while (System.currentTimeMillis() < this.endTimeStampMs) {
            Path path = new Path(mapperSpecifcPathPrefix + "/file" + numFilesCreated);
            FSDataOutputStream out = this.fs.create(path);
            out.write(content);
            out.close();
            mapperContext.getCounter((Enum)CREATEFILECOUNTERS.NUMFILESCREATED).increment(1L);
            if (++numFilesCreated % 1000L == 0L) {
                mapperContext.progress();
                System.out.println("Number of files created: " + numFilesCreated);
            }
            if (!this.shouldDelete) continue;
            this.fs.delete(path, true);
        }
    }

    public static enum CREATEFILECOUNTERS {
        NUMFILESCREATED;

    }
}

