/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Random;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CipherSuite;
import org.apache.hadoop.crypto.CryptoCodec;
import org.apache.hadoop.crypto.Decryptor;
import org.apache.hadoop.crypto.Encryptor;
import org.apache.hadoop.crypto.OpensslCipher;
import org.apache.hadoop.crypto.random.OpensslSecureRandom;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class OpensslCtrCryptoCodec
extends CryptoCodec {
    private Configuration conf;
    private Random random;
    private String engineId;

    public String getEngineId() {
        return this.engineId;
    }

    public void setEngineId(String engineId) {
        this.engineId = engineId;
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    public void calculateIV(byte[] initIV, long counter, byte[] iv, int blockSize) {
        Preconditions.checkArgument(initIV.length == blockSize);
        Preconditions.checkArgument(iv.length == blockSize);
        int i = iv.length;
        int j = 0;
        int sum = 0;
        while (i-- > 0) {
            sum = (initIV[i] & 0xFF) + (sum >>> 8);
            if (j++ < 8) {
                sum += (byte)counter & 0xFF;
                counter >>>= 8;
            }
            iv[i] = (byte)sum;
        }
    }

    protected abstract Logger getLogger();

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
        Class<Random> klass = conf.getClass("hadoop.security.secure.random.impl", OpensslSecureRandom.class, Random.class);
        try {
            this.random = ReflectionUtils.newInstance(klass, conf);
            this.getLogger().debug("Using " + klass.getName() + " as random number generator.");
        }
        catch (Exception e) {
            this.getLogger().info("Unable to use " + klass.getName() + ".  Falling back to Java SecureRandom.", (Throwable)e);
            this.random = new SecureRandom();
        }
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void generateSecureRandom(byte[] bytes) {
        this.random.nextBytes(bytes);
    }

    @Override
    public void close() throws IOException {
        if (this.random instanceof Closeable) {
            Closeable r = (Closeable)((Object)this.random);
            IOUtils.cleanupWithLogger(this.getLogger(), r);
        }
    }

    protected static class OpensslCtrCipher
    implements Encryptor,
    Decryptor {
        private final OpensslCipher cipher;
        private final int mode;
        private boolean contextReset = false;

        public OpensslCtrCipher(int mode, CipherSuite suite, String engineId) throws GeneralSecurityException {
            this.mode = mode;
            this.cipher = OpensslCipher.getInstance(suite.getName(), engineId);
        }

        public OpensslCtrCipher(int mode, CipherSuite suite) throws GeneralSecurityException {
            this.mode = mode;
            this.cipher = OpensslCipher.getInstance(suite.getName());
        }

        @Override
        public void init(byte[] key, byte[] iv) throws IOException {
            Preconditions.checkNotNull(key);
            Preconditions.checkNotNull(iv);
            this.contextReset = false;
            this.cipher.init(this.mode, key, iv);
        }

        @Override
        public void encrypt(ByteBuffer inBuffer, ByteBuffer outBuffer) throws IOException {
            this.process(inBuffer, outBuffer);
        }

        @Override
        public void decrypt(ByteBuffer inBuffer, ByteBuffer outBuffer) throws IOException {
            this.process(inBuffer, outBuffer);
        }

        private void process(ByteBuffer inBuffer, ByteBuffer outBuffer) throws IOException {
            try {
                int inputSize = inBuffer.remaining();
                int n = this.cipher.update(inBuffer, outBuffer);
                if (n < inputSize) {
                    this.contextReset = true;
                    this.cipher.doFinal(outBuffer);
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        @Override
        public boolean isContextReset() {
            return this.contextReset;
        }
    }
}

