/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal.creation.bytebuddy;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.Callable;
import org.apache.hadoop.shaded.net.bytebuddy.asm.Advice;
import org.apache.hadoop.shaded.net.bytebuddy.description.method.MethodDescription;
import org.apache.hadoop.shaded.net.bytebuddy.description.type.TypeDescription;
import org.apache.hadoop.shaded.net.bytebuddy.dynamic.scaffold.MethodGraph;
import org.apache.hadoop.shaded.net.bytebuddy.implementation.bind.annotation.Argument;
import org.apache.hadoop.shaded.net.bytebuddy.implementation.bind.annotation.This;
import org.apache.hadoop.shaded.net.bytebuddy.implementation.bytecode.assign.Assigner;
import org.apache.hadoop.shaded.org.mockito.exceptions.base.MockitoException;
import org.apache.hadoop.shaded.org.mockito.internal.creation.bytebuddy.MockAccess;
import org.apache.hadoop.shaded.org.mockito.internal.creation.bytebuddy.MockMethodInterceptor;
import org.apache.hadoop.shaded.org.mockito.internal.creation.bytebuddy.inject.MockMethodDispatcher;
import org.apache.hadoop.shaded.org.mockito.internal.debugging.LocationImpl;
import org.apache.hadoop.shaded.org.mockito.internal.exceptions.stacktrace.ConditionalStackTraceFilter;
import org.apache.hadoop.shaded.org.mockito.internal.invocation.RealMethod;
import org.apache.hadoop.shaded.org.mockito.internal.invocation.SerializableMethod;
import org.apache.hadoop.shaded.org.mockito.internal.invocation.mockref.MockReference;
import org.apache.hadoop.shaded.org.mockito.internal.invocation.mockref.MockWeakReference;
import org.apache.hadoop.shaded.org.mockito.internal.util.concurrent.WeakConcurrentMap;

public class MockMethodAdvice
extends MockMethodDispatcher {
    private final WeakConcurrentMap<Object, MockMethodInterceptor> interceptors;
    private final String identifier;
    private final SelfCallInfo selfCallInfo = new SelfCallInfo();
    private final MethodGraph.Compiler compiler = MethodGraph.Compiler.Default.forJavaHierarchy();
    private final WeakConcurrentMap<Class<?>, SoftReference<MethodGraph>> graphs = new WeakConcurrentMap.WithInlinedExpunction();

    public MockMethodAdvice(WeakConcurrentMap<Object, MockMethodInterceptor> interceptors, String identifier) {
        this.interceptors = interceptors;
        this.identifier = identifier;
    }

    @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
    private static Callable<?> enter(@Identifier String identifier, @Advice.This Object mock, @Advice.Origin Method origin, @Advice.AllArguments Object[] arguments) throws Throwable {
        MockMethodDispatcher dispatcher = MockMethodDispatcher.get((String)identifier, (Object)mock);
        if (dispatcher == null || !dispatcher.isMocked(mock) || dispatcher.isOverridden(mock, origin)) {
            return null;
        }
        return dispatcher.handle(mock, origin, arguments);
    }

    @Advice.OnMethodExit
    private static void exit(@Advice.Return(readOnly=false, typing=Assigner.Typing.DYNAMIC) Object returned, @Advice.Enter Callable<?> mocked) throws Throwable {
        if (mocked != null) {
            returned = mocked.call();
        }
    }

    static Throwable hideRecursiveCall(Throwable throwable, int current, Class<?> targetType) {
        try {
            StackTraceElement next;
            StackTraceElement[] stack = throwable.getStackTrace();
            int skip = 0;
            while (!(next = stack[stack.length - current - ++skip]).getClassName().equals(targetType.getName())) {
            }
            int top = stack.length - current - skip;
            StackTraceElement[] cleared = new StackTraceElement[stack.length - skip];
            System.arraycopy(stack, 0, cleared, 0, top);
            System.arraycopy(stack, top + skip, cleared, top, current);
            throwable.setStackTrace(cleared);
            return throwable;
        }
        catch (RuntimeException ignored) {
            return throwable;
        }
    }

    public Callable<?> handle(Object instance, Method origin, Object[] arguments) throws Throwable {
        MockMethodInterceptor interceptor = this.interceptors.get(instance);
        if (interceptor == null) {
            return null;
        }
        RealMethod realMethod = instance instanceof Serializable ? new SerializableRealMethodCall(this.identifier, origin, instance, arguments) : new RealMethodCall(this.selfCallInfo, origin, instance, arguments);
        return new ReturnValueWrapper(interceptor.doIntercept(instance, origin, arguments, realMethod, new LocationImpl(new Throwable(), true)));
    }

    public boolean isMock(Object instance) {
        return instance != this.interceptors.target && this.interceptors.containsKey(instance);
    }

    public boolean isMocked(Object instance) {
        return this.selfCallInfo.checkSuperCall(instance) && this.isMock(instance);
    }

    public boolean isOverridden(Object instance, Method origin) {
        MethodGraph.Node node;
        MethodGraph methodGraph;
        SoftReference<MethodGraph> reference = this.graphs.get(instance.getClass());
        MethodGraph methodGraph2 = methodGraph = reference == null ? null : reference.get();
        if (methodGraph == null) {
            methodGraph = this.compiler.compile(new TypeDescription.ForLoadedType(instance.getClass()));
            this.graphs.put(instance.getClass(), new SoftReference<MethodGraph>(methodGraph));
        }
        return !(node = methodGraph.locate(new MethodDescription.ForLoadedMethod(origin).asSignatureToken())).getSort().isResolved() || !((MethodDescription.InDefinedShape)node.getRepresentative().asDefined()).getDeclaringType().represents(origin.getDeclaringClass());
    }

    private static Object tryInvoke(Method origin, Object instance, Object[] arguments) throws Throwable {
        try {
            return origin.invoke(instance, arguments);
        }
        catch (InvocationTargetException exception) {
            Throwable cause = exception.getCause();
            new ConditionalStackTraceFilter().filter(MockMethodAdvice.hideRecursiveCall(cause, new Throwable().getStackTrace().length, origin.getDeclaringClass()));
            throw cause;
        }
    }

    public static class ForReadObject {
        public static void doReadObject(@Identifier String identifier, @This MockAccess thiz, @Argument(value=0) ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            MockMethodAdvice mockMethodAdvice = (MockMethodAdvice)MockMethodDispatcher.get((String)identifier, (Object)thiz);
            if (mockMethodAdvice != null) {
                mockMethodAdvice.interceptors.put(thiz, thiz.getMockitoInterceptor());
            }
        }
    }

    static class ForEquals {
        ForEquals() {
        }

        @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
        private static boolean enter(@Identifier String identifier, @Advice.This Object self) {
            MockMethodDispatcher dispatcher = MockMethodDispatcher.get((String)identifier, (Object)self);
            return dispatcher != null && dispatcher.isMock(self);
        }

        @Advice.OnMethodExit
        private static void enter(@Advice.This Object self, @Advice.Argument(value=0) Object other, @Advice.Return(readOnly=false) boolean equals, @Advice.Enter boolean skipped) {
            if (skipped) {
                equals = self == other;
            }
        }
    }

    static class ForHashCode {
        ForHashCode() {
        }

        @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
        private static boolean enter(@Identifier String id, @Advice.This Object self) {
            MockMethodDispatcher dispatcher = MockMethodDispatcher.get((String)id, (Object)self);
            return dispatcher != null && dispatcher.isMock(self);
        }

        @Advice.OnMethodExit
        private static void enter(@Advice.This Object self, @Advice.Return(readOnly=false) int hashCode, @Advice.Enter boolean skipped) {
            if (skipped) {
                hashCode = System.identityHashCode(self);
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Identifier {
    }

    private static class SelfCallInfo
    extends ThreadLocal<Object> {
        private SelfCallInfo() {
        }

        Object replace(Object value) {
            Object current = this.get();
            this.set(value);
            return current;
        }

        boolean checkSuperCall(Object value) {
            if (value == this.get()) {
                this.set(null);
                return false;
            }
            return true;
        }
    }

    private static class ReturnValueWrapper
    implements Callable<Object> {
        private final Object returned;

        private ReturnValueWrapper(Object returned) {
            this.returned = returned;
        }

        @Override
        public Object call() {
            return this.returned;
        }
    }

    private static class SerializableRealMethodCall
    implements RealMethod {
        private final String identifier;
        private final SerializableMethod origin;
        private final MockReference<Object> instanceRef;
        private final Object[] arguments;

        private SerializableRealMethodCall(String identifier, Method origin, Object instance, Object[] arguments) {
            this.origin = new SerializableMethod(origin);
            this.identifier = identifier;
            this.instanceRef = new MockWeakReference<Object>(instance);
            this.arguments = arguments;
        }

        @Override
        public boolean isInvokable() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke() throws Throwable {
            MockMethodDispatcher mockMethodDispatcher;
            Method method = this.origin.getJavaMethod();
            if (!Modifier.isPublic(method.getDeclaringClass().getModifiers() & method.getModifiers())) {
                method.setAccessible(true);
            }
            if (!((mockMethodDispatcher = MockMethodDispatcher.get((String)this.identifier, (Object)this.instanceRef.get())) instanceof MockMethodAdvice)) {
                throw new MockitoException("Unexpected dispatcher for advice-based super call");
            }
            Object previous = ((MockMethodAdvice)mockMethodDispatcher).selfCallInfo.replace(this.instanceRef.get());
            try {
                Object object = MockMethodAdvice.tryInvoke(method, this.instanceRef.get(), this.arguments);
                return object;
            }
            finally {
                ((MockMethodAdvice)mockMethodDispatcher).selfCallInfo.set(previous);
            }
        }
    }

    private static class RealMethodCall
    implements RealMethod {
        private final SelfCallInfo selfCallInfo;
        private final Method origin;
        private final MockWeakReference<Object> instanceRef;
        private final Object[] arguments;

        private RealMethodCall(SelfCallInfo selfCallInfo, Method origin, Object instance, Object[] arguments) {
            this.selfCallInfo = selfCallInfo;
            this.origin = origin;
            this.instanceRef = new MockWeakReference<Object>(instance);
            this.arguments = arguments;
        }

        @Override
        public boolean isInvokable() {
            return true;
        }

        @Override
        public Object invoke() throws Throwable {
            if (!Modifier.isPublic(this.origin.getDeclaringClass().getModifiers() & this.origin.getModifiers())) {
                this.origin.setAccessible(true);
            }
            this.selfCallInfo.set(this.instanceRef.get());
            return MockMethodAdvice.tryInvoke(this.origin, this.instanceRef.get(), this.arguments);
        }
    }
}

