/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hbase.JUnitResourceCheckers;
import org.apache.hadoop.hbase.ResourceChecker;
import org.junit.runner.Description;
import org.junit.runner.notification.RunListener;

public class ResourceCheckerJUnitListener
extends RunListener {
    private final Map<String, ResourceChecker> rcs = new ConcurrentHashMap<String, ResourceChecker>();

    protected void addResourceAnalyzer(ResourceChecker rc) {
    }

    private void start(String testName) {
        ResourceChecker rc = new ResourceChecker(testName);
        JUnitResourceCheckers.addResourceAnalyzer(rc);
        this.addResourceAnalyzer(rc);
        this.rcs.put(testName, rc);
        rc.start();
    }

    private void end(String testName) {
        ResourceChecker rc = this.rcs.remove(testName);
        assert (rc != null);
        rc.end();
    }

    private String descriptionToShortTestName(Description description) {
        int toRemove = "org.apache.hadoop.hbase.".length();
        return description.getTestClass().getName().substring(toRemove) + "#" + description.getMethodName();
    }

    public void testStarted(Description description) throws Exception {
        this.start(this.descriptionToShortTestName(description));
    }

    public void testFinished(Description description) throws Exception {
        this.end(this.descriptionToShortTestName(description));
    }
}

