/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.crypto.tls;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.io.crypto.tls.AbstractTestX509Parameterized;
import org.apache.hadoop.hbase.io.crypto.tls.KeyStoreFileType;
import org.apache.hadoop.hbase.io.crypto.tls.PEMFileLoader;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={SecurityTests.class, SmallTests.class})
public class TestPEMFileLoader
extends AbstractTestX509Parameterized {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestPEMFileLoader.class);

    @Test
    public void testLoadKeyStore() throws Exception {
        String path = this.x509TestContext.getKeyStoreFile(KeyStoreFileType.PEM).getAbsolutePath();
        KeyStore ks = ((PEMFileLoader)new PEMFileLoader.Builder().setKeyStorePath(path).setKeyStorePassword(this.x509TestContext.getKeyStorePassword()).build()).loadKeyStore();
        Assert.assertEquals((long)1L, (long)ks.size());
    }

    @Test(expected=Exception.class)
    public void testLoadKeyStoreWithWrongPassword() throws Exception {
        String path = this.x509TestContext.getKeyStoreFile(KeyStoreFileType.PEM).getAbsolutePath();
        ((PEMFileLoader)new PEMFileLoader.Builder().setKeyStorePath(path).setKeyStorePassword("wrong password".toCharArray()).build()).loadKeyStore();
    }

    @Test(expected=IOException.class)
    public void testLoadKeyStoreWithWrongFilePath() throws Exception {
        String path = this.x509TestContext.getKeyStoreFile(KeyStoreFileType.PEM).getAbsolutePath();
        ((PEMFileLoader)new PEMFileLoader.Builder().setKeyStorePath(path + ".does_not_exist").setKeyStorePassword(this.x509TestContext.getKeyStorePassword()).build()).loadKeyStore();
    }

    @Test(expected=NullPointerException.class)
    public void testLoadKeyStoreWithNullFilePath() throws Exception {
        ((PEMFileLoader)new PEMFileLoader.Builder().setKeyStorePassword(this.x509TestContext.getKeyStorePassword()).build()).loadKeyStore();
    }

    @Test(expected=KeyStoreException.class)
    public void testLoadKeyStoreWithWrongFileType() throws Exception {
        String path = this.x509TestContext.getKeyStoreFile(KeyStoreFileType.JKS).getAbsolutePath();
        ((PEMFileLoader)new PEMFileLoader.Builder().setKeyStorePath(path).setKeyStorePassword(this.x509TestContext.getKeyStorePassword()).build()).loadKeyStore();
    }

    @Test
    public void testLoadTrustStore() throws Exception {
        String path = this.x509TestContext.getTrustStoreFile(KeyStoreFileType.PEM).getAbsolutePath();
        KeyStore ts = ((PEMFileLoader)new PEMFileLoader.Builder().setTrustStorePath(path).setTrustStorePassword(this.x509TestContext.getTrustStorePassword()).build()).loadTrustStore();
        Assert.assertEquals((long)1L, (long)ts.size());
    }

    @Test(expected=IOException.class)
    public void testLoadTrustStoreWithWrongFilePath() throws Exception {
        String path = this.x509TestContext.getTrustStoreFile(KeyStoreFileType.PEM).getAbsolutePath();
        ((PEMFileLoader)new PEMFileLoader.Builder().setTrustStorePath(path + ".does_not_exist").setTrustStorePassword(this.x509TestContext.getTrustStorePassword()).build()).loadTrustStore();
    }

    @Test(expected=NullPointerException.class)
    public void testLoadTrustStoreWithNullFilePath() throws Exception {
        ((PEMFileLoader)new PEMFileLoader.Builder().setTrustStorePassword(this.x509TestContext.getTrustStorePassword()).build()).loadTrustStore();
    }

    @Test
    public void testLoadTrustStoreWithWrongFileType() throws Exception {
        String path = this.x509TestContext.getTrustStoreFile(KeyStoreFileType.JKS).getAbsolutePath();
        KeyStore ts = ((PEMFileLoader)new PEMFileLoader.Builder().setTrustStorePath(path).setTrustStorePassword(this.x509TestContext.getTrustStorePassword()).build()).loadTrustStore();
        Assert.assertEquals((long)0L, (long)ts.size());
    }
}

